/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.debug.DebugEngineHub;
import kd.sdk.kingscript.debug.client.DebugClient;
import kd.sdk.kingscript.debug.client.LocalDebugClient;
import kd.sdk.kingscript.debug.client.inspect.domain.Debugger;
import kd.sdk.kingscript.debug.client.inspect.domain.Runtime;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerReady;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.debug.dlock.DLocker;
import kd.sdk.kingscript.debug.ws.registry.WsClientRegistry;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.listener.EngineListener;
import kd.sdk.kingscript.log.Loggable;
import kd.sdk.kingscript.pool.KingScriptEnginePool;

public final class AutoDebugEngineManager
implements Loggable {
    private final Supplier<KingScriptEngine> normalEngineSupplier;
    private final Supplier<KingScriptEngine> debugEngineSupplier;
    private final String enginePoolName;

    public AutoDebugEngineManager(String enginePoolName) {
        this(enginePoolName, () -> KingScriptEnginePool.get(enginePoolName).acquire(), () -> KingScriptEnginePool.getDebug(enginePoolName).acquire());
    }

    public AutoDebugEngineManager(String enginePoolName, Supplier<KingScriptEngine> normalEngineSupplier, Supplier<KingScriptEngine> debugEngineSupplier) {
        this.normalEngineSupplier = normalEngineSupplier;
        this.debugEngineSupplier = debugEngineSupplier;
        this.enginePoolName = enginePoolName;
    }

    public KingScriptEngine getEngine(String startDebugScriptPath) {
        String sessionId = AccountProvider.get().getSessionId();
        String debugId = DebugInfoRegistry.get().findDebugId(startDebugScriptPath, this.enginePoolName, sessionId);
        if (debugId == null || DebuggerDisable.isDisabled(debugId)) {
            return this.normalEngineSupplier.get();
        }
        String lockKey = "kingscript.debugEngineKeeper." + debugId;
        DLocker debugEngineKeeper = AccountProvider.get().tryLock(lockKey, DebugConfig.getDebugEngineKeepTime());
        if (DebuggerDisable.isDisabled(debugId)) {
            debugEngineKeeper.close();
            return this.normalEngineSupplier.get();
        }
        KingScriptEngine engine = this.debugEngineSupplier.get();
        this.attach(debugId, engine, debugEngineKeeper);
        return engine;
    }

    private void attach(final String debugId, KingScriptEngine engine, final DLocker debugEngineKeeper) {
        engine.unwrap(KingScriptEngineImpl.class).setDebugId(debugId);
        String wsUrl = engine.getDebugUrl();
        WsClientRegistry.get().register(debugId, wsUrl, AccountProvider.get().getInstanceIp());
        DebugEngineHub.addEngine(debugId, engine);
        final LocalDebugClient debugClient = (LocalDebugClient)DebugClient.getOrCreate(debugId);
        debugClient.connect(wsUrl);
        final Debugger debugger = debugClient.getDebugger();
        final Runtime runtime = debugClient.getRuntime();
        EngineListener el = new EngineListener(){

            @Override
            public void onEvalBegin(KingScriptEngine engine, String scriptPath) {
                debugger.notifyDebuggerEvalBegan(scriptPath, "[" + Thread.currentThread().getName() + "] " + engine.toString());
            }

            @Override
            public void onEvalEnd(KingScriptEngine engine, String scriptPath) {
                debugger.notifyDebuggerEvalEnded(scriptPath, "[" + Thread.currentThread().getName() + "] " + engine.toString());
            }

            @Override
            public void onEvalException(KingScriptEngine engine, String scriptPath, Throwable e) {
                StringWriter sw = new StringWriter(1024);
                e.printStackTrace(new PrintWriter(sw));
                String error = engine + " eval " + scriptPath + " error: \r\n" + sw;
                Loggable.logger.info("[" + debugId + "] " + error);
                runtime.notifyConsoleError(error);
            }

            @Override
            public void awaitForClose(KingScriptEngine engine) {
                debugClient.waitComplete();
            }

            @Override
            public void onClosed(KingScriptEngine engine) {
                try {
                    DebugEngineHub.removeEngine(debugId, engine);
                    engine.removeListener(this);
                    debugClient.disconnect();
                }
                finally {
                    debugEngineKeeper.close();
                }
            }
        };
        engine.addListener(el);
        DebugInfoRegistry diRegistry = DebugInfoRegistry.get();
        int round = diRegistry.incRequestEngineRound(debugId);
        if (round == 1) {
            runtime.runAsync(() -> {
                logger.info("[" + debugId + "] Round-1 Got engine: " + engine);
                debugger.notifyPrepared();
            });
            DebuggerReady.wait(debugId);
        } else {
            logger.info("[" + debugId + "] Round-" + round + " Switch engine " + engine);
            debugger.switchEngine();
        }
    }
}

