/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug;

import kd.sdk.kingscript.debug.cache.DebugCache;
import kd.sdk.kingscript.engine.KingScriptEngine;

public final class DebugEngineHub {
    private KingScriptEngine engine;
    private Thread lastWebSocketThread;

    public static void removeCache(String debugId) {
        DebugCache.remove(debugId + "#engine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void addEngine(String debugId, KingScriptEngine engine) {
        DebugEngineHub hub = (DebugEngineHub)DebugCache.get(debugId + "#engine");
        if (hub == null) {
            hub = new DebugEngineHub();
            DebugCache.set(debugId + "#engine", hub);
        }
        DebugEngineHub debugEngineHub = hub;
        synchronized (debugEngineHub) {
            assert (hub.engine != engine);
            if (hub.engine != null && !hub.engine.isClosed()) {
                throw new UnsupportedOperationException("[" + debugId + "] Can not attach more then one debug engine, previous active engine is: " + hub.engine);
            }
            hub.engine = engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeEngine(String debugId, KingScriptEngine engine) {
        DebugEngineHub hub = (DebugEngineHub)DebugCache.get(debugId + "#engine");
        if (hub != null) {
            DebugEngineHub debugEngineHub = hub;
            synchronized (debugEngineHub) {
                assert (hub.engine == engine);
                hub.engine = null;
            }
        }
    }

    public static KingScriptEngine getEngine(String debugId) {
        DebugEngineHub hub = (DebugEngineHub)DebugCache.get(debugId + "#engine");
        return hub == null ? null : hub.engine;
    }

    public static Thread getWebSocketThread(String debugId) {
        DebugEngineHub hub = (DebugEngineHub)DebugCache.get(debugId + "#engine");
        return hub == null ? null : hub.lastWebSocketThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWebSocketThread(String debugId) {
        DebugEngineHub hub = (DebugEngineHub)DebugCache.get(debugId + "#engine");
        if (hub != null) {
            DebugEngineHub debugEngineHub = hub;
            synchronized (debugEngineHub) {
                hub.lastWebSocketThread = Thread.currentThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWebSocketThread(String debugId) {
        DebugEngineHub hub = (DebugEngineHub)DebugCache.get(debugId + "#engine");
        if (hub != null) {
            DebugEngineHub debugEngineHub = hub;
            synchronized (debugEngineHub) {
                hub.lastWebSocketThread = null;
            }
        }
    }
}

