/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug;

import java.util.Map;
import java.util.concurrent.Callable;
import kd.sdk.kingscript.config.LazySetHolder;
import kd.sdk.kingscript.debug.DebugThreadLocalRestorer;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.util.Call;

public final class DebugThreadLocalRestorers<T> {
    private static final String WITH_DEBUG_THREAD_LOCAL_TAG = "++";
    private static final boolean mark_debug_thread_name = true;
    private static final LazySetHolder<DebugThreadLocalRestorer> HOLDER = new LazySetHolder<Object>("kingscript.debug.ThreadLocalRestorer", null);

    public static void install(String debugId) {
        Map<String, String> env;
        if (HOLDER.get() != null && (env = HOLDER.get().get()) != null && !env.isEmpty()) {
            DebugInfoRegistry.get().setEnv(debugId, env);
        }
    }

    private static void set(String debugId) {
        DebugThreadLocalRestorers.markDebugThread();
        if (HOLDER.get() != null) {
            Map<String, String> env = DebugInfoRegistry.get().getEnv(debugId);
            HOLDER.get().set(env);
        }
    }

    private static void remove(String debugId) {
        if (HOLDER.get() != null) {
            HOLDER.get().remove();
        }
        DebugThreadLocalRestorers.unMarkDebugThread();
    }

    private static void markDebugThread() {
        String name = Thread.currentThread().getName();
        if (!name.startsWith(WITH_DEBUG_THREAD_LOCAL_TAG)) {
            Thread.currentThread().setName(WITH_DEBUG_THREAD_LOCAL_TAG + name);
        }
    }

    private static void unMarkDebugThread() {
        String name = Thread.currentThread().getName();
        if (name.startsWith(WITH_DEBUG_THREAD_LOCAL_TAG)) {
            Thread.currentThread().setName(name.substring(WITH_DEBUG_THREAD_LOCAL_TAG.length()));
        }
    }

    public static <V> V callInRestored(String debugId, Callable<V> callable) throws Exception {
        DebugThreadLocalRestorers.set(debugId);
        try {
            V v = callable.call();
            return v;
        }
        finally {
            DebugThreadLocalRestorers.remove(debugId);
        }
    }

    public static void callInRestored(String debugId, Call call) {
        DebugThreadLocalRestorers.set(debugId);
        try {
            call.call();
        }
        finally {
            DebugThreadLocalRestorers.remove(debugId);
        }
    }
}

