/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import kd.sdk.kingscript.debug.cache.DebugCacheable;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.log.Logs;

public final class DebugCache {
    private static final LoadingCache<String, Object> cache = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterAccess(DebugConfig.getTimeout(), TimeUnit.MILLISECONDS).initialCapacity(16).maximumSize(8192L).recordStats().removalListener((RemovalListener)new RemovalListener<String, Object>(){

        public void onRemoval(RemovalNotification<String, Object> notification) {
            Object obj = notification.getValue();
            try {
                if (obj instanceof DebugCacheable) {
                    ((DebugCacheable)obj).clearDebug();
                }
            }
            finally {
                Logs.getLogger().info("[DebugCache] " + (String)notification.getKey() + " was removed, cause is " + notification.getCause() + ".");
            }
        }
    }).build((CacheLoader)new CacheLoader<String, Object>(){

        public Object load(String key) throws ScriptException {
            return null;
        }
    });

    public static <T> T get(String key) {
        return (T)cache.asMap().get(key);
    }

    public static void set(String key, Object obj) {
        cache.asMap().put(key, obj);
    }

    public static void remove(String key) {
        cache.asMap().remove(key);
    }
}

