/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.cache.expiring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.kingscript.debug.cache.expiring.ExpiringCache;
import kd.sdk.kingscript.debug.cache.expiring.RemovalCause;
import kd.sdk.kingscript.debug.cache.expiring.RemovalListener;

final class LocalExpiringCache<K, V>
implements ExpiringCache<K, V> {
    private static final AtomicInteger timeoutThreadSeq = new AtomicInteger();
    private final long defaultTimeout;
    private final Map<K, Value<V>> map = new ConcurrentHashMap<K, Value<V>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private RemovalListener listener = null;

    public LocalExpiringCache(long defaultTimeout, TimeUnit timeUnit) {
        this.defaultTimeout = this.milliseconds(defaultTimeout, timeUnit);
        this.startCheckTimeout();
    }

    private long milliseconds(long timeout, TimeUnit timeUnit) {
        if (timeUnit != TimeUnit.MILLISECONDS) {
            return TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        }
        return timeout;
    }

    private boolean isTimeout(Value value) {
        return value.lastSet + value.timeout < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            Value<V> v = this.map.get(key);
            if (v != null) {
                if (this.isTimeout(v)) {
                    return this.doRemove(key, RemovalCause.EXPIRED);
                }
                return v.value;
            }
            return null;
        }
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(K key, V value, long timeout, TimeUnit timeUnit) {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            if (this.closed.get()) {
                throw new IllegalStateException(this + " has closed");
            }
            V oldValue = this.get(key);
            this.map.put(key, new Value(value, System.currentTimeMillis(), this.milliseconds(timeout, timeUnit)));
            if (oldValue != null && oldValue != value) {
                this.fireRemoved(key, oldValue, RemovalCause.REPLACED);
            }
            this.closed.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeout(K key, long timeout, TimeUnit timeUnit) {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            Value<V> v = this.map.get(key);
            if (v != null) {
                v.lastSet = System.currentTimeMillis();
                v.timeout = this.milliseconds(timeout, timeUnit);
            }
        }
    }

    @Override
    public V remove(K key) {
        return this.doRemove(key, RemovalCause.EXPLICIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            for (K key : new HashSet<K>(this.map.keySet())) {
                this.doRemove(key, RemovalCause.EXPLICIT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V doRemove(K key, RemovalCause removalCause) {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            Value<V> value = this.map.remove(key);
            if (value != null) {
                this.fireRemoved(key, value.value, removalCause);
                return value.value;
            }
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void refresh(K key) {
        this.get(key);
    }

    @Override
    public void refreshAll() {
        for (K key : new ArrayList<K>(this.map.keySet())) {
            this.get(key);
        }
    }

    private void startCheckTimeout() {
        Thread th = new Thread(() -> {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                while (!this.closed.get()) {
                    long wait = this.defaultTimeout;
                    if (!this.map.isEmpty()) {
                        for (K key : new ArrayList<K>(this.map.keySet())) {
                            Value<V> value = this.map.get(key);
                            if (value != null && this.isTimeout(value)) {
                                this.doRemove(key, RemovalCause.EXPIRED);
                                continue;
                            }
                            if (value.timeout >= wait) continue;
                            wait = value.timeout;
                        }
                    }
                    if (this.closed.get()) break;
                    try {
                        this.closed.wait(wait);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        });
        th.setDaemon(true);
        th.setName("KingScript-Debug-" + this.getClass().getSimpleName() + "-" + timeoutThreadSeq.incrementAndGet());
        th.start();
    }

    @Override
    public ExpiringCache<K, V> setRemovalListener(RemovalListener listener) {
        this.listener = listener;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            if (this.closed.compareAndSet(false, true)) {
                this.clear();
            }
        }
    }

    private void fireRemoved(K key, V value, RemovalCause removalCause) {
        if (this.listener != null) {
            this.listener.onRemoval(key, value, removalCause);
        }
    }

    private static class Value<V> {
        final V value;
        long lastSet;
        long timeout;

        private Value(V value, long lastSet, long timeout) {
            this.value = value;
            this.lastSet = lastSet;
            this.timeout = timeout;
        }
    }
}

