/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.callchain;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import kd.sdk.kingscript.debug.callchain.DebugCallSpan;
import kd.sdk.kingscript.debug.client.inspect.command.MessageType;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.log.Loggable;

public final class DebugCallChain {
    public static DebugCallSpan create(String debugId, String cid, String sid, String method, MessageType type, String detail) {
        return DebugCallSpan.create(debugId, cid, sid, method, type, detail);
    }

    public static void logCallChain(String debugId) {
        List<DebugCallSpan> spans = DebugInfoRegistry.get().getDebugCallSpanList(debugId);
        if (spans.isEmpty()) {
            return;
        }
        try {
            Collections.sort(spans, (o1, o2) -> {
                int dt = (int)(o1.getTsBegin() - o2.getTsBegin());
                if (dt == 0) {
                    dt = (int)(o1.getSid() - o2.getSid());
                }
                if (dt == 0) {
                    dt = o1.getMessageType() - o2.getMessageType();
                }
                return dt;
            });
            long totalCost = spans.get(spans.size() - 1).getTsEnd() - spans.get(0).getTsBegin();
            long insideCost = 0L;
            int remoteCall = 0;
            for (DebugCallSpan span : spans) {
                if (!span.isRemoteCall()) {
                    insideCost += span.getTsEnd() - span.getTsBegin();
                    continue;
                }
                ++remoteCall;
            }
            long outsideCost = totalCost - insideCost;
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            StringBuilder log = new StringBuilder(4096).append("[DebugCallChain] ").append("{ totalCall: ").append(spans.size()).append(", remoteCall: ").append(remoteCall).append(", totalCost: ").append(totalCost).append(", insideCost: ").append(insideCost).append(", outsideCost: ").append(outsideCost).append(", debugId: ").append(debugId).append(" } :");
            log.append("\r\n[simple]");
            int responseMessageType = MessageType.RESPONSE_METHOD.ordinal();
            for (DebugCallSpan span : spans) {
                String method;
                if (span.getMessageType() == responseMessageType || (method = span.getMethod()).equals("Runtime.consoleAPICalled") || method.equals("Debugger.keepAlive")) continue;
                log.append("\r\n\t").append(span.toSimpleString(sdf));
            }
            log.append("\r\n[full]");
            for (DebugCallSpan span : spans) {
                log.append("\r\n\t").append(span.toDetailString(sdf));
            }
            Loggable.logger.info(log.toString());
        }
        catch (Throwable e) {
            Loggable.logger.error("[" + debugId + "] logCallChain error: " + e.getMessage(), e);
        }
    }
}

