/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.callchain;

import java.text.SimpleDateFormat;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.debug.client.inspect.command.MessageType;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;

public class DebugCallSpan
implements AutoCloseable {
    private String debugId;
    private long sid;
    private String cid;
    private int messageType;
    private String method;
    private long tsBegin;
    private long tsEnd;
    private String detail;
    private boolean remoteCall;

    static DebugCallSpan create(String debugId, String cid, String sid, String method, MessageType type, String detail) {
        DebugCallSpan span = new DebugCallSpan();
        span.debugId = debugId;
        span.cid = cid == null ? "-" : cid;
        span.sid = sid == null || sid.isEmpty() ? 0L : Long.parseLong(sid);
        span.method = method;
        span.messageType = type.ordinal();
        span.detail = AccountProvider.get().getInstanceIp() + " | " + detail;
        span.tsBegin = System.currentTimeMillis();
        if (method.equals("Debugger.disable")) {
            span.tsEnd = span.tsBegin;
            DebugInfoRegistry.get().addDebugCallSpan(debugId, span);
        }
        return span;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public void setDebugId(String debugId) {
        this.debugId = debugId;
    }

    public long getSid() {
        return this.sid;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public long getTsBegin() {
        return this.tsBegin;
    }

    public void setTsBegin(long tsBegin) {
        this.tsBegin = tsBegin;
    }

    public long getTsEnd() {
        return this.tsEnd;
    }

    public void setTsEnd(long tsEnd) {
        this.tsEnd = tsEnd;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean isRemoteCall() {
        return this.remoteCall;
    }

    public void setRemoteCall(boolean remoteCall) {
        this.remoteCall = remoteCall;
    }

    public String toDetailString(SimpleDateFormat sdf) {
        StringBuilder sb = new StringBuilder(128).append(this.toSimpleString(sdf));
        sb.append(", ").append(this.tsEnd - this.tsBegin);
        sb.append(", ").append(this.detail);
        return sb.toString();
    }

    public String toSimpleString(SimpleDateFormat sdf) {
        StringBuilder sb = new StringBuilder(64);
        boolean request = this.messageType == MessageType.REQUEST_METHOD.ordinal();
        sb.append(request ? "-->" : "<--");
        sb.append(this.cid).append('-').append(this.sid).append(' ').append(this.method).append(' ').append(sdf.format(this.tsBegin));
        return sb.toString();
    }

    @Override
    public void close() {
        this.tsEnd = System.currentTimeMillis();
        if (!this.method.equals("Debugger.disable")) {
            DebugInfoRegistry.get().addDebugCallSpan(this.debugId, this);
        }
    }
}

