/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.command;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Optional;

public final class Params {
    private final JSONObject json;

    public Params(JSONObject json) {
        this.json = json;
    }

    public static Params createContext(long id, String name) {
        JSONObject params = new JSONObject();
        JSONObject context = new JSONObject();
        context.put("id", (Object)id);
        context.put("name", (Object)name);
        context.put("origin", (Object)"");
        params.put("context", (Object)context);
        return new Params(params);
    }

    public static Params createContextId(long id) {
        JSONObject params = new JSONObject();
        params.put("executionContextId", (Object)id);
        return new Params(params);
    }

    public static Params createConsoleAPICalled(String type, Object text, long contextId) {
        JSONObject params = new JSONObject();
        params.put("type", (Object)type);
        JSONArray args = new JSONArray();
        if (text != null) {
            JSONObject outObject = new JSONObject();
            if (text instanceof String) {
                outObject.put("type", (Object)"string");
            } else if (text instanceof Number) {
                outObject.put("type", (Object)"number");
            }
            outObject.put("value", text);
            args.add((Object)outObject);
        }
        params.put("args", (Object)args);
        params.put("executionContextId", (Object)contextId);
        params.put("timestamp", (Object)((double)System.nanoTime() / 1000000.0));
        return new Params(params);
    }

    public JSONObject getJSONObject() {
        return this.json;
    }

    public String[] getPatterns() {
        if (this.json.get((Object)"patterns") != null) {
            JSONArray patterns = this.json.getJSONArray("patterns");
            return (String[])patterns.toArray((Object[])new String[patterns.size()]);
        }
        return new String[0];
    }

    public long getSamplingInterval() {
        if (this.json.get((Object)"interval") != null) {
            return this.json.getLong("interval");
        }
        return -1L;
    }

    public int getMaxDepth() {
        if (this.json.get((Object)"maxDepth") != null) {
            return this.json.getInteger("maxDepth");
        }
        return 0;
    }

    public String getState() {
        if (this.json.get((Object)"state") != null) {
            return this.json.getString("state");
        }
        return "none";
    }

    public String getScriptId() {
        if (this.json.get((Object)"scriptId") != null) {
            return this.json.getString("scriptId");
        }
        return null;
    }

    public Optional<Boolean> getBoolean(String name) {
        if (this.json.get((Object)name) != null) {
            return Optional.of(this.json.getBoolean(name));
        }
        return Optional.empty();
    }

    public String getBreakpointId() {
        if (this.json.get((Object)"breakpointId") != null) {
            return this.json.getString("breakpointId");
        }
        return null;
    }

    public String toString() {
        return this.json.toString();
    }
}

