/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain;

import kd.sdk.kingscript.debug.client.LocalDebugClient;
import kd.sdk.kingscript.debug.client.inspect.domain.AbstractDomain;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerEvalBegan;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerEvalEnded;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerPaused;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerPrepared;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerResumed;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerScriptParsed;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEchoCommand;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEnable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEvaluateOnCallFrame;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGetPossibleBreakpoints;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGetProperties;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGetScriptSource;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGo;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerKeepAlive;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerPause;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerPrepare;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerReady;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerRemoveBreakpoint;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerResume;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointsActive;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetPauseOnExceptions;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetSkipAllPauses;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetVariableValue;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepInto;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepOut;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepOver;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSwitchEngine;

public class Debugger
extends AbstractDomain {
    public Debugger(LocalDebugClient debugClient) {
        super(debugClient);
    }

    public void notifyPaused() {
        this.debugClient.sendBack(DebuggerPaused.REQUEST_MESSAGE);
    }

    public void notifyPrepared() {
        this.debugClient.sendBack(DebuggerPrepared.REQUEST_MESSAGE);
    }

    public void notifyResumed() {
        this.debugClient.sendBack(DebuggerResumed.REQUEST_MESSAGE);
    }

    public void notifyDebuggerEvalBegan(String scriptPath, String description) {
        this.debugClient.sendBack(DebuggerEvalBegan.create(scriptPath, description));
    }

    public void notifyDebuggerEvalEnded(String scriptPath, String description) {
        this.debugClient.sendBack(DebuggerEvalEnded.create(scriptPath, description));
    }

    public String enable() {
        return this.debugClient.requestSync(DebuggerEnable.REQUEST_MESSAGE);
    }

    public String disable() {
        return this.debugClient.requestSync(DebuggerDisable.REQUEST_MESSAGE);
    }

    public String prepare(String enginePoolName, String ... scriptPaths) {
        return this.debugClient.requestSync(DebuggerPrepare.create(enginePoolName, scriptPaths));
    }

    public String ready() {
        return this.debugClient.requestSync(DebuggerReady.REQUEST_MESSAGE);
    }

    public String go() {
        return this.debugClient.requestSync(DebuggerGo.REQUEST_MESSAGE);
    }

    public String pause() {
        return this.debugClient.requestSync(DebuggerPause.REQUEST_MESSAGE);
    }

    public String removeBreakpoint(String breakpointId) {
        return this.debugClient.requestSync(DebuggerRemoveBreakpoint.create(breakpointId));
    }

    public String resume() {
        return this.debugClient.requestSync(DebuggerResume.create(false));
    }

    public String setBreakpointByUrl(String url, int lineNumber) {
        return this.setBreakpointByUrl(url, null, lineNumber, 0, "");
    }

    public String setBreakpointByUrl(String url, int lineNumber, String condition) {
        return this.setBreakpointByUrl(url, null, lineNumber, 0, condition);
    }

    public String setBreakpointByUrl(String url, String urlRegex, int lineNumber, int columnNumber, String condition) {
        return this.debugClient.requestSync(DebuggerSetBreakpointByUrl.create(url, urlRegex, lineNumber, columnNumber, condition));
    }

    public String setPauseOnExceptions(DebuggerSetPauseOnExceptions.Mode mode) {
        return this.debugClient.requestSync(DebuggerSetPauseOnExceptions.create(mode));
    }

    public String setBreakpointsActive(boolean active) {
        return this.debugClient.requestSync(DebuggerSetBreakpointsActive.create(active));
    }

    public String setSkipAllPauses(boolean skip) {
        return this.debugClient.requestSync(DebuggerSetSkipAllPauses.create(skip));
    }

    public String stepInto() {
        return this.debugClient.requestSync(DebuggerStepInto.REQUEST_MESSAGE);
    }

    public String stepOut() {
        return this.debugClient.requestSync(DebuggerStepOut.REQUEST_MESSAGE);
    }

    public String stepOver() {
        return this.debugClient.requestSync(DebuggerStepOver.REQUEST_MESSAGE);
    }

    public String evaluateOnCallFrame(String callFrameId, String expression, boolean silent) {
        return this.debugClient.requestSync(DebuggerEvaluateOnCallFrame.create(callFrameId, expression, silent));
    }

    public String setVariableValue(String variableName, Object value) {
        return this.debugClient.requestSync(DebuggerSetVariableValue.create(variableName, value));
    }

    public String switchEngine() {
        return this.debugClient.requestSync(DebuggerSwitchEngine.REQUEST_MESSAGE);
    }

    public String getProperties(String objectId) {
        return this.debugClient.requestSync(DebuggerGetProperties.create(objectId));
    }

    public String getScriptSource(String scriptId) {
        return this.debugClient.requestSync(DebuggerGetScriptSource.create(scriptId));
    }

    public String getScriptSourceByUrl(String url) {
        return this.getScriptSource(DebuggerScriptParsed.getScriptId(this.debugClient.getDebugId(), url));
    }

    public String getPossibleBreakpoints(String scriptId, int lineIndex) {
        return this.debugClient.requestSync(DebuggerGetPossibleBreakpoints.create(scriptId, lineIndex));
    }

    public String getPossibleBreakpointsByUrl(String url, int lineIndex) {
        return this.getPossibleBreakpoints(DebuggerScriptParsed.getScriptId(this.debugClient.getDebugId(), url), lineIndex);
    }

    public String keepAlive() {
        return this.debugClient.requestSync(DebuggerKeepAlive.create());
    }

    public String keepAlive(long timeout) {
        return this.debugClient.requestSync(DebuggerKeepAlive.create(timeout));
    }

    public String echoCommand(boolean echo) {
        return this.debugClient.requestSync(DebuggerEchoCommand.create(echo));
    }
}

