/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain;

import kd.sdk.kingscript.debug.client.LocalDebugClient;
import kd.sdk.kingscript.debug.client.inspect.domain.AbstractDomain;
import kd.sdk.kingscript.debug.client.inspect.domain.event.RuntimeConsoleAPICalled;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeDisable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeEnable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeEvaluate;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeGetProperties;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeRunIfWaitingForDebugger;

public class Runtime
extends AbstractDomain {
    public Runtime(LocalDebugClient debugClient) {
        super(debugClient);
    }

    public void notifyConsoleLog(Object text) {
        this.debugClient.sendBack(RuntimeConsoleAPICalled.create(RuntimeConsoleAPICalled.ConsoleAPICalledEventType.log, this.debugClient.getDebugId(), text));
    }

    public void notifyConsoleError(Object text) {
        this.debugClient.sendBack(RuntimeConsoleAPICalled.create(RuntimeConsoleAPICalled.ConsoleAPICalledEventType.error, this.debugClient.getDebugId(), text));
    }

    public String enable() {
        return this.debugClient.requestSync(RuntimeEnable.REQUEST_MESSAGE);
    }

    public String runIfWaitingForDebugger() {
        return this.debugClient.requestSync(RuntimeRunIfWaitingForDebugger.REQUEST_MESSAGE);
    }

    public String disable() {
        return this.debugClient.requestSync(RuntimeDisable.REQUEST_MESSAGE);
    }

    public String evaluate(String expression, boolean silent) {
        return this.debugClient.requestSync(RuntimeEvaluate.create(expression, silent));
    }

    public String getProperties(String objectId) {
        return this.debugClient.requestSync(RuntimeGetProperties.create(objectId));
    }
}

