/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import kd.sdk.kingscript.debug.cache.DebugCache;
import kd.sdk.kingscript.debug.client.LocalDebugClient;
import kd.sdk.kingscript.debug.client.SteppedTiming;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.client.inspect.interceptor.CustomCommandInterceptor;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.exception.ScriptException;

public class DebuggerGo
extends AbstractMethodInterceptor
implements CustomCommandInterceptor {
    public static final String METHOD = "Debugger.go";
    public static final String REQUEST_MESSAGE = Command.createMethod("Debugger.go", null).toJSONString();
    private static final Object setDebugCacheNotifier = new Object();

    @Override
    public boolean isPseudoMethod() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String interceptRequest(String debugId, String msg, Command cmd) {
        Object object;
        String key = DebuggerGo.createLockKey(debugId);
        Object lock = DebugCache.get(key);
        if (lock == null) {
            object = setDebugCacheNotifier;
            synchronized (object) {
                while ((lock = DebugCache.get(key)) == null) {
                    try {
                        setDebugCacheNotifier.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        if (lock == null) {
            throw new ScriptException("Debugger script engine not prepared: " + debugId);
        }
        DebugCache.remove(key);
        object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(String debugId) {
        LocalDebugClient.logKDP("Waiting for Debugger.go - " + debugId);
        Object lock = new Object();
        String key = DebuggerGo.createLockKey(debugId);
        DebugCache.set(key, lock);
        Object object = setDebugCacheNotifier;
        synchronized (object) {
            setDebugCacheNotifier.notifyAll();
        }
        try {
            SteppedTiming.wait(DebugConfig.getDebuggerGoOrDebuggerReadyTimeout(), 1000L, lock, () -> {
                boolean waked = false;
                if (DebugCache.get(key) == null) {
                    LocalDebugClient.logKDP("Waked Debugger.go - " + debugId);
                    waked = true;
                }
                if (DebuggerDisable.isDisabled(debugId)) {
                    DebugCache.remove(key);
                    LocalDebugClient.logKDP("Waked Debugger.go cause debugger disabled - " + debugId);
                    waked = true;
                }
                return waked;
            });
        }
        catch (InterruptedException e) {
            DebugCache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyIfStillWait(String debugId) {
        String key = DebuggerGo.createLockKey(debugId);
        Object lock = DebugCache.get(key);
        if (lock != null) {
            Object t = lock;
            synchronized (t) {
                lock.notifyAll();
            }
        }
    }

    private static String createLockKey(String debugId) {
        return debugId + "." + METHOD + ".lock";
    }

    public static String createForApi(long cid) {
        return Command.createAPI(cid, METHOD, null).toJSONString();
    }
}

