/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import com.alibaba.fastjson.JSONObject;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.command.Params;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.exception.ScriptException;

public class DebuggerRemoveBreakpoint
extends AbstractMethodInterceptor {
    public static final String METHOD = "Debugger.removeBreakpoint";

    @Override
    public String interceptRequest(String debugId, String msg, Command cmd) {
        DebugInfoRegistry dir = DebugInfoRegistry.get();
        String enginePoolName = dir.findEnginePoolName(debugId);
        if (enginePoolName == null) {
            throw new ScriptException("[" + debugId + "] Debugger not prepared, call " + "Debugger.prepare" + " before " + METHOD + ".");
        }
        return msg;
    }

    public static String create(String breakpointId) {
        JSONObject json = new JSONObject();
        json.put("breakpointId", (Object)breakpointId);
        return Command.createMethod(METHOD, new Params(json)).toJSONString();
    }

    public static String createForApi(long cid, String breakpointId) {
        JSONObject json = new JSONObject();
        json.put("breakpointId", (Object)breakpointId);
        return Command.createAPI(cid, METHOD, new Params(json)).toJSONString();
    }
}

