/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.debug.DebugEngineHub;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.command.Params;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.ByteSeekableByteChannel;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;

public class DebuggerSetBreakpointByUrl
extends AbstractMethodInterceptor {
    public static final String METHOD = "Debugger.setBreakpointByUrl";

    @Override
    public String interceptRequest(String debugId, String msg, Command cmd) {
        DebugInfoRegistry dir = DebugInfoRegistry.get();
        String enginePoolName = dir.findEnginePoolName(debugId);
        if (enginePoolName == null) {
            return msg;
        }
        JSONObject params = cmd.getParams().getJSONObject();
        String url = params.getString("url");
        dir.register(debugId, new String[]{url}, enginePoolName, AccountProvider.get().getSessionId(), AccountProvider.get().getUserName());
        int lineNumber = params.getInteger("lineNumber");
        int columnNumber = params.getInteger("columnNumber");
        SourceMap.Location targetLocation = DebuggerSetBreakpointByUrl.mappingTargetLocation(cmd.getDebugId(), url, new SourceMap.Location(lineNumber, columnNumber));
        if (targetLocation == null) {
            return null;
        }
        if (targetLocation.getLineNumber() != lineNumber || targetLocation.getColumnNumber() != columnNumber) {
            params.put("lineNumber", (Object)targetLocation.getLineNumber());
            params.put("columnNumber", (Object)targetLocation.getColumnNumber());
            return cmd.toJSONString();
        }
        return msg;
    }

    public static String create(String url, String urlRegex, int lineNumber, int columnNumber, String condition) {
        JSONObject json = new JSONObject();
        json.put("url", (Object)(url == null ? "" : url));
        json.put("urlRegex", (Object)(urlRegex == null ? "" : urlRegex));
        json.put("lineNumber", (Object)lineNumber);
        json.put("columnNumber", (Object)columnNumber);
        json.put("condition", (Object)condition);
        return Command.createMethod(METHOD, new Params(json)).toJSONString();
    }

    public static String formatScriptPath(String scriptPath) {
        return ScriptPathFormat.format(scriptPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SourceMap.Location mappingTargetLocation(String debugId, String scriptPath, SourceMap.Location sourceLocation) {
        KingScriptEngine engine = DebugEngineHub.getEngine(debugId);
        if (engine == null) {
            return null;
        }
        LibFileSystem libFileSystem = engine.unwrap(KingScriptEngineImpl.class).getLibFileSystem();
        try (ByteSeekableByteChannel bc = libFileSystem.newByteChannel(scriptPath);){
            SourceMap sourceMap = bc.getSourceMap();
            SourceMap.Location location = sourceMap.getTargetLocation(sourceLocation);
            return location;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SourceMap.Location mappingSourceLocation(String debugId, String scriptPath, SourceMap.Location targetLocation) {
        KingScriptEngine engine = DebugEngineHub.getEngine(debugId);
        if (engine == null) {
            return null;
        }
        LibFileSystem libFileSystem = engine.unwrap(KingScriptEngineImpl.class).getLibFileSystem();
        try (ByteSeekableByteChannel bc = libFileSystem.newByteChannel(scriptPath);){
            SourceMap sourceMap = bc.getSourceMap();
            SourceMap.Location location = sourceMap.getSourceLocation(targetLocation);
            return location;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public static String createForApi(long cid, String url, long lineNumber, long columnNumber) {
        JSONObject json = new JSONObject();
        json.put("url", (Object)url);
        json.put("lineNumber", (Object)lineNumber);
        json.put("columnNumber", (Object)columnNumber);
        return Command.createAPI(cid, METHOD, new Params(json)).toJSONString();
    }
}

