/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.ws;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.kingscript.debug.ws.WsClient;
import kd.sdk.kingscript.debug.ws.protocol.InspectProtocol;
import kd.sdk.kingscript.debug.ws.protocol.PushMessageHandler;
import kd.sdk.kingscript.exception.ScriptException;

public final class WsClientImpl
implements WsClient {
    private final String debugId;
    private final String wsUrl;
    private final InspectProtocol protocol;
    private final AtomicBoolean disconnected = new AtomicBoolean();

    public WsClientImpl(String debugId, String wsUrl, PushMessageHandler pushMessageHandler) {
        this.debugId = debugId;
        this.wsUrl = wsUrl;
        this.protocol = new InspectProtocol(debugId, wsUrl, pushMessageHandler);
    }

    @Override
    public void connect() {
        this.protocol.connect();
    }

    @Override
    public void send(String msg) {
        this.ensureConnect();
        this.protocol.send(new String[]{msg});
    }

    @Override
    public void disconnect() {
        if (this.disconnected.compareAndSet(false, true)) {
            this.protocol.close();
        }
    }

    private void ensureConnect() {
        if (this.disconnected.get()) {
            throw new ScriptException("[" + this.debugId + "] WsSocket has disconnected (wsUrl=" + this.wsUrl + ").");
        }
    }
}

