/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.ws.protocol;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.sdk.kingscript.debug.ws.protocol.PushMessageHandler;
import kd.sdk.kingscript.exception.DebugConnectTimeoutException;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.log.Logs;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;

@WebSocket(maxTextMessageSize=0x4000000)
public class WsSocket {
    private static final Logger logger = Logs.getLogger();
    private static final long timeout_seconds = 10L;
    private final PushMessageHandler pushMessageHandler;
    private Session session;
    private final CountDownLatch connectLatch = new CountDownLatch(1);

    public WsSocket(PushMessageHandler pushMessageHandler) {
        this.pushMessageHandler = pushMessageHandler;
    }

    public void sendMessage(String ... messages) {
        try {
            boolean isDebugEnabled = logger.isDebugEnabled();
            for (String msg : messages) {
                if (isDebugEnabled) {
                    logger.debug("Send message: " + msg);
                }
                Future fut = this.session.getRemote().sendStringByFuture(msg);
                fut.get(10L, TimeUnit.SECONDS);
            }
        }
        catch (Throwable t) {
            throw ScriptException.asRuntime(t);
        }
    }

    public void close() {
        this.session.close(1000, "");
        if (logger.isDebugEnabled()) {
            logger.debug("Close: " + this.session);
        }
    }

    public void awaitConnect() throws InterruptedException {
        if (!this.connectLatch.await(10L, TimeUnit.SECONDS)) {
            throw new DebugConnectTimeoutException("awaitConnect exceed 10 seconds");
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
        if (logger.isDebugEnabled()) {
            logger.debug("Got connect: " + session);
        }
        this.connectLatch.countDown();
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug("Receive message: " + msg);
        }
        this.pushMessageHandler.pushMessage(msg);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug("Connection closed: " + statusCode + (reason == null ? "" : " - " + reason));
        }
    }
}

