/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.ws.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.config.LazySetHolder;
import kd.sdk.kingscript.debug.ws.registry.WsClientRegistryStore;
import kd.sdk.kingscript.util.Tuple;

class WsClientRegistryStoreHolder {
    private static final WsClientRegistryStore DEFAULT = new WsClientRegistryStore(){
        private Map<String, Tuple<String, String>> registryMap = new ConcurrentHashMap<String, Tuple<String, String>>();

        @Override
        public String getWsUrl(String debugId) {
            Tuple<String, String> values = this.registryMap.get(debugId);
            return values == null ? null : values.getKey();
        }

        @Override
        public String getIp(String debugId) {
            Tuple<String, String> values = this.registryMap.get(debugId);
            return values == null ? null : values.getValue();
        }

        @Override
        public void set(String debugId, String wsUrl, String ip) {
            this.registryMap.put(debugId, new Tuple<String, String>(wsUrl, ip));
        }

        @Override
        public void remove(String debugId) {
            this.registryMap.remove(debugId);
        }
    };
    static final LazySetHolder<WsClientRegistryStore> HOLDER = new LazySetHolder<WsClientRegistryStore>("kingscript.debug.WsClientRegistryStore", DEFAULT);

    WsClientRegistryStoreHolder() {
    }
}

