/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.util.LRUCache;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.engine.InternalEngineFactory;
import kd.sdk.kingscript.lib.ByteSeekableByteChannel;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.transpiler.BabelTranspiler;
import kd.sdk.kingscript.transpiler.TransResult;
import org.slf4j.Logger;

public final class GlobalCache {
    private static final Logger logger = Logs.getLogger();
    private static final GlobalCache INSTANCE = new GlobalCache();
    private final Map<String, TransResult> transpilerCache = Collections.synchronizedMap(new LRUCache(4096));
    private final Map<String, ByteSeekableByteChannel> libFileSystemCache = Collections.synchronizedMap(new LRUCache(4096));
    private final Map<String, ScriptInfo> storeFileCache = Collections.synchronizedMap(new LRUCache(4096));
    private final Map<String, JSModuleRecord> esModuleMap = new ConcurrentHashMap<String, JSModuleRecord>();
    private Map<String, String> esModuleLastVersionedPathMap = new ConcurrentHashMap<String, String>();

    public static GlobalCache get() {
        return INSTANCE;
    }

    private GlobalCache() {
    }

    public Map<String, TransResult> getTranspilerCache() {
        return this.transpilerCache;
    }

    public Map<String, ByteSeekableByteChannel> getLibFileSystemCache() {
        return this.libFileSystemCache;
    }

    public Map<String, ScriptInfo> getStoreFileCache() {
        return this.storeFileCache;
    }

    public Map<String, JSModuleRecord> getESModuleMap() {
        return this.esModuleMap;
    }

    public Map<String, String> getESModuleLastVersionedPathMap() {
        return this.esModuleLastVersionedPathMap;
    }

    public void clearAllCache() {
        this.transpilerCache.clear();
        this.libFileSystemCache.clear();
        ScriptVersionManager.clearAllIfLocalMemoryStore();
        this.storeFileCache.clear();
        this.esModuleMap.clear();
        InternalEngineFactory.clearEngineCache();
        BabelTranspiler.clearEngineCache();
    }

    public void log() {
        StringBuilder msg = new StringBuilder(1024);
        msg.append("\n----GlobalCache----");
        msg.append("\ntranspiler:    ").append(this.transpilerCache.size());
        msg.append("\nlibFileSystem: ").append(this.libFileSystemCache.size());
        msg.append("\nstoreFile:     ").append(this.storeFileCache.size());
        msg.append("\nmodule:        ").append(this.esModuleMap.size());
        msg.append("\nmoduleVersion: ").append(this.esModuleLastVersionedPathMap.size());
        msg.append("\n---------------------------");
        logger.info(msg.toString());
    }
}

