/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.SimpleBindings;
import kd.sdk.kingscript.engine.ScriptOptions;
import kd.sdk.kingscript.engine.SdkHostAccess;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.types.mapping.TypeMappings;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;

final class InternalEngineFactory {
    private static final SimpleBindings globalBinding = new SimpleBindings(Collections.synchronizedMap(new HashMap()));
    private static final int KEEP_MAX_DEBUG_SHARED_ENGINE = 0;
    private static volatile Engine sharedEngine;
    private static Map<String, Engine> debugSharedEngineMap;
    private static Map<Engine, AtomicInteger> refCountMap;
    private static HostAccess sharedHostAccess;

    InternalEngineFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetSharedEngine() {
        sharedEngine = Engine.newBuilder().allowExperimentalOptions(true).build();
        Map<Engine, AtomicInteger> map = refCountMap;
        synchronized (map) {
            refCountMap.put(sharedEngine, new AtomicInteger());
        }
    }

    static void clearEngineCache() {
        InternalEngineFactory.resetSharedEngine();
    }

    static HostAccess getSharedHostAccess() {
        return sharedHostAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onClosed(Engine engine) {
        Map<Engine, AtomicInteger> map = refCountMap;
        synchronized (map) {
            AtomicInteger refCount = refCountMap.get(engine);
            int count = refCount.decrementAndGet();
            if (count == 0 && engine != sharedEngine) {
                if (debugSharedEngineMap.containsValue(engine)) {
                    if (debugSharedEngineMap.size() > 0) {
                        Map<String, Engine> map2 = debugSharedEngineMap;
                        synchronized (map2) {
                            if (debugSharedEngineMap.size() > 0) {
                                for (String key : new ArrayList<String>(debugSharedEngineMap.keySet())) {
                                    if (debugSharedEngineMap.get(key) != engine) continue;
                                    engine.close();
                                    debugSharedEngineMap.remove(key);
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    engine.close();
                    refCountMap.remove(engine);
                }
            }
        }
    }

    public static GraalJSScriptEngine createSharedEngine(Context.Builder ctxBuilder) {
        return InternalEngineFactory.createEngine(sharedEngine, ctxBuilder);
    }

    public static GraalJSScriptEngine createDebugEngine(Context.Builder ctxBuilder, ScriptOptions options) {
        Engine.Builder engineBuilder = Engine.newBuilder();
        int port = options.getDebugOptions().getPort();
        if (port < 0) {
            port = 0;
        }
        boolean secure = false;
        String inspect = "localhost:" + port;
        String path = "/cosmic/kingscript/" + UUID.randomUUID().toString().replace("-", "");
        engineBuilder.option("inspect", inspect);
        engineBuilder.option("inspect.Secure", String.valueOf(secure));
        engineBuilder.option("inspect.Suspend", "false");
        engineBuilder.option("inspect.WaitAttached", "false");
        engineBuilder.option("inspect.Path", path);
        Logs.getLogger().info("Debug KingScript: chrome://inspect");
        Engine debugEngine = engineBuilder.allowExperimentalOptions(true).build();
        debugSharedEngineMap.put(debugEngine.toString(), debugEngine);
        return InternalEngineFactory.createEngine(debugEngine, ctxBuilder);
    }

    private static String getDevtoolsAddress(boolean secure, String inspect, String path) {
        return "devtools://devtools/bundled/js_app.html?" + (secure ? "wss" : "ws") + "=" + inspect + path;
    }

    private static GraalJSScriptEngine createEngine(Engine engine, Context.Builder ctxBuilder) {
        GraalJSScriptEngine scriptEngine = GraalJSScriptEngine.create(engine, ctxBuilder);
        scriptEngine.setBindings(globalBinding, 200);
        AtomicInteger refCount = refCountMap.computeIfAbsent(engine, k -> new AtomicInteger());
        refCount.incrementAndGet();
        return scriptEngine;
    }

    static {
        debugSharedEngineMap = new ConcurrentHashMap<String, Engine>(0);
        refCountMap = new ConcurrentHashMap<Engine, AtomicInteger>();
        InternalEngineFactory.resetSharedEngine();
        HostAccess.Builder accessBuilder = HostAccess.newBuilder((HostAccess)SdkHostAccess.SDK);
        TypeMappings.setup(accessBuilder);
        sharedHostAccess = accessBuilder.build();
    }
}

