/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.engine.ModuleExports;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.security.IgnoreSecurityCheck;
import org.slf4j.Logger;

class ModuleExportsManager {
    private static final Logger logger = Logs.getLogger();
    private static volatile boolean sharedResolved = false;

    ModuleExportsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleExports listModuleExports(KingScriptEngineImpl engine, String ... modules) {
        if (!sharedResolved) {
            ModuleExports shared;
            ModuleExports moduleExports = shared = ModuleExports.getOrCreate("ACCOUNT_SHARED");
            synchronized (moduleExports) {
                if (!sharedResolved) {
                    try (IgnoreSecurityCheck isc = IgnoreSecurityCheck.setup();){
                        ModuleExportsManager.listModuleExports0(engine, shared, ModuleExports.getSharedExportModules().toArray(new String[0]));
                    }
                    sharedResolved = true;
                }
            }
        }
        ModuleExports me = ModuleExports.getOrCreate();
        ModuleExportsManager.listModuleExports0(engine, me, modules);
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleExports listModuleExports0(KingScriptEngineImpl engine, ModuleExports me, String ... modules) {
        logger.info("listModuleExports modules: " + Arrays.toString(modules));
        modules = ModuleExports.getSortedModules(modules);
        ModuleExports moduleExports = me;
        synchronized (moduleExports) {
            boolean modified = false;
            HashSet<String> oldUsed = new HashSet<String>(me.getUsedModuleSet());
            for (String module : modules) {
                int p;
                Map<String, List<String>> typesMap;
                me.addUsedModule(module);
                String oldVersion = me.getModuleVersion(module);
                if (ModuleExports.isConstVersionModule(module) && (!me.isShared() || oldVersion != null) || (typesMap = engine.listModuleTypes(module)).isEmpty()) continue;
                ArrayList<String> types = new ArrayList<String>(1024);
                typesMap.values().forEach(types::addAll);
                if (ModuleExports.isConstVersionModule(module)) {
                    ModuleExports.addConstVersionModules(module, types);
                }
                String maxVersion = null;
                for (String type : types) {
                    p = type.indexOf("&v=");
                    if (p == -1) continue;
                    String version = type.substring(p + 3);
                    if (maxVersion != null && maxVersion.compareTo(version) >= 0) continue;
                    maxVersion = version;
                }
                if (maxVersion == null) {
                    maxVersion = "";
                }
                if (oldVersion != null) {
                    if (oldVersion.equals(maxVersion)) continue;
                    me.removeModule(module);
                }
                if (!modified) {
                    modified = true;
                }
                me.setModuleVersion(module, maxVersion);
                for (String type : types) {
                    p = type.indexOf(".d.ts");
                    if (p == -1) continue;
                    String path = type.substring(0, p);
                    try {
                        engine.evalLib(path);
                        for (String export : engine.getBindings().getExport().getMemberKeys()) {
                            me.addExport(path, export);
                        }
                    }
                    catch (Exception e) {
                        me.addError(path, e.getMessage());
                        logger.warn("listPathExports " + path + " error: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (!modified) {
                oldUsed.removeAll(me.getUsedModuleSet());
                if (!oldUsed.isEmpty()) {
                    modified = true;
                }
            }
            if (modified || me.toJSONString() == null) {
                me.genJSONString();
            }
        }
        logger.info("listModuleExports return: " + me);
        return me;
    }
}

