/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.debug.DebugOptions;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.security.CachedSecurityController;
import kd.sdk.kingscript.security.DefaultSecurityController;
import kd.sdk.kingscript.security.SecurityController;
import kd.sdk.kingscript.transpiler.TranslationOptions;

@ConfigurableItem(desc="\u811a\u672c\u5f15\u64ce\u9009\u9879")
public class ScriptOptions {
    private final TranslationOptions translationOptions = new TranslationOptions();
    private final DebugOptions debugOptions = new DebugOptions();
    private final Map<String, String> otherOptions = new HashMap<String, String>();
    private final List<LibModule> libModules = new ArrayList<LibModule>();
    private SecurityController securityController;
    private SecurityController cachedSecurityController;
    private boolean interactive;
    private boolean preheat = true;
    private String[] preheatScriptPaths;
    private boolean catInteropException = true;
    private boolean logEnabled = false;
    private ScriptStore scriptStore;

    public static ScriptOptions createDefault() {
        return new ScriptOptions();
    }

    public ScriptOptions() {
        this.setSecurityController(DefaultSecurityController.INSTANCE);
    }

    public TranslationOptions getTranslationOptions() {
        return this.translationOptions;
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void addModule(LibModule libModule) {
        this.libModules.add(libModule);
    }

    public LibModule[] getLibModules() {
        return this.libModules.toArray(new LibModule[this.libModules.size()]);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isPreheat() {
        return this.preheat;
    }

    public void setPreheat(boolean preheat) {
        this.preheat = preheat;
    }

    public String[] getPreheatScriptPaths() {
        return this.preheatScriptPaths;
    }

    public void setPreheatScriptPaths(String ... preheatScriptPaths) {
        this.preheatScriptPaths = preheatScriptPaths;
    }

    public void option(String key, String value) {
        this.otherOptions.put(key, value);
    }

    public Map<String, String> getOtherOptions() {
        return this.otherOptions;
    }

    public boolean isCatInteropException() {
        return this.catInteropException;
    }

    public void setCatInteropException(boolean catInteropException) {
        this.catInteropException = catInteropException;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public ScriptStore getScriptStore() {
        return this.scriptStore;
    }

    public void setScriptStore(ScriptStore scriptStore) {
        this.scriptStore = scriptStore;
    }

    public SecurityController getSecurityController() {
        return this.securityController;
    }

    public SecurityController getCachedSecurityController() {
        return this.cachedSecurityController;
    }

    public final void setSecurityController(SecurityController securityController) {
        this.securityController = securityController;
        this.cachedSecurityController = CachedSecurityController.of(securityController);
    }
}

