/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;

public final class ThreadSharedEngine {
    public static KingScriptEngine create(Supplier<KingScriptEngine> engineSupplier) {
        KingScriptEngine engine = KingScriptEngine.getCurrent();
        KingScriptEngine proxy = engine == null ? ThreadSharedEngine.wrapperAsSharedEngine(engineSupplier) : (engine instanceof SharedEngine ? engine : ThreadSharedEngine.wrapperAsSharedEngine(() -> engine));
        ((SharedEngine)((Object)proxy)).__incRefCount();
        return proxy;
    }

    private static KingScriptEngine wrapperAsSharedEngine(Supplier<KingScriptEngine> engineSupplier) {
        KingScriptEngine engine = KingScriptEngine.getCurrent();
        if (engine == null) {
            engine = engineSupplier.get();
        }
        KingScriptEngine obj = engine;
        AtomicInteger refCounter = new AtomicInteger();
        KingScriptEngine ret = (KingScriptEngine)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{KingScriptEngine.class, SharedEngine.class}, (proxy, method, args) -> {
            String name;
            switch (name = method.getName()) {
                case "__incRefCount": {
                    refCounter.incrementAndGet();
                    return null;
                }
                case "close": {
                    int count = refCounter.decrementAndGet();
                    if (count > 0) {
                        return null;
                    }
                    refCounter.set(0);
                    break;
                }
                case "equals": {
                    return args[0] == proxy;
                }
            }
            return method.invoke((Object)obj, args);
        });
        KingScriptEngineImpl.getCurrentEngineImpl().setTopWrapper(ret);
        return ret;
    }

    public static interface SharedEngine {
        public void __incRefCount();
    }
}

