/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine.bindings;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.util.Set;
import kd.sdk.kingscript.engine.bindings.ScriptBinding;
import kd.sdk.kingscript.engine.bindings.ScriptBindingImpl;
import kd.sdk.kingscript.engine.bindings.ScriptBindings;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.types.ScriptValue;
import kd.sdk.kingscript.types.ScriptValueImpl;
import org.graalvm.polyglot.Value;

public final class ScriptBindingsImpl
implements ScriptBindings {
    private final ScriptBindingImpl hostThis;
    private final ScriptBindingImpl hostGlobal;
    private final Value jsThis;
    private ScriptValue export;

    public ScriptBindingsImpl(GraalJSScriptEngine scriptEngine) {
        this.hostThis = new ScriptBindingImpl(scriptEngine.getContext().getBindings(100));
        this.hostGlobal = new ScriptBindingImpl(scriptEngine.getContext().getBindings(200));
        this.jsThis = GraalJSScriptEngine.evalInternal(scriptEngine.getPolyglotContext(), "this");
    }

    @Override
    public <T> T get(String key) {
        return this.hostThis.get(key);
    }

    @Override
    public void put(String key, Object value) {
        this.checkKey(key);
        this.hostThis.put(key, value);
    }

    @Override
    public void putConst(String key, Object value) {
        this.checkKey(key);
        this.hostThis.putConst(key, value);
    }

    @Override
    public void putGlobal(String key, Object value) {
        this.checkKey(key);
        this.hostThis.putGlobal(key, value);
    }

    private void checkKey(String key) {
        if (key.startsWith("polyglot.js.")) {
            throw new ScriptException("key can not start with: polyglot.js.");
        }
    }

    @Override
    public void clear() {
        this.hostThis.clear();
        this.export = null;
    }

    @Override
    public Set<String> keySet() {
        return this.hostThis.keySet();
    }

    @Override
    public Set<String> constKeySet() {
        return this.hostThis.constKeySet();
    }

    public Set<String> constKeySet0() {
        return this.hostThis.constKeySet;
    }

    @Override
    public Set<String> globalKeySet() {
        return this.hostThis.globalKeySet();
    }

    public Set<String> globalKeySet0() {
        return this.hostThis.globalKeySet;
    }

    @Override
    public int size() {
        return this.hostThis.size();
    }

    @Override
    public boolean has(String key) {
        return this.hostThis.has(key);
    }

    @Override
    public Object remove(String key) {
        return this.hostThis.remove(key);
    }

    @Override
    public ScriptValue getExport() {
        return this.export;
    }

    public void setExport(ScriptValue export) {
        this.export = export;
    }

    @Override
    public ScriptBinding getGlobalBinding() {
        return this.hostGlobal;
    }

    @Override
    public ScriptValue getScriptValue(String identifier) {
        return ScriptValueImpl.create(this.jsThis.getMember(identifier));
    }
}

