/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine.inherit;

import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.host.HostObject;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Optional;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.types.Types;
import org.graalvm.polyglot.Value;

public final class InheritUtil {
    public static final String adapterClassNameSuffix = "$$Adapter";
    private static final Class<?> clsGeneratedClassLoader;

    public static boolean isAdapterClass(Class<?> cls) {
        return cls.getClassLoader().getClass() == clsGeneratedClassLoader;
    }

    public static boolean isCallExtendConstructor(MethodHandle methodHandle) {
        try {
            Method arg = methodHandle.getClass().getSuperclass().getDeclaredMethod("arg", Integer.TYPE);
            arg.setAccessible(true);
            Object value = arg.invoke((Object)methodHandle, 0);
            if (value.getClass().getName().equals("java.lang.invoke.DirectMethodHandle$Constructor") && value.toString().endsWith(adapterClassNameSuffix)) {
                return true;
            }
        }
        catch (Exception e) {
            throw ScriptException.asRuntime(e);
        }
        return false;
    }

    public static Optional<Object> invokeScriptMember(Object receiver, String functionName, Object[] callArguments) throws UnknownIdentifierException, UnsupportedMessageException {
        Object adapterObject;
        if (receiver instanceof HostObject && (adapterObject = Types.js2java(receiver)).getClass().getName().endsWith(adapterClassNameSuffix)) {
            try {
                Object scriptThis = adapterObject.getClass().getDeclaredField("this").get(adapterObject);
                Value value = (Value)scriptThis;
                Object callReturn = Types.js2java(value.invokeMember(functionName, callArguments));
                return Optional.of(callReturn);
            }
            catch (Exception ex) {
                throw UnknownIdentifierException.create((String)functionName);
            }
        }
        return Optional.empty();
    }

    static {
        try {
            clsGeneratedClassLoader = Class.forName("com.oracle.truffle.host.HostAdapterClassLoader$GeneratedClassLoader");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

