/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.exception;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.host.HostException;
import com.oracle.truffle.js.runtime.JSException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.exception.InternalExceptionCat;
import kd.sdk.kingscript.lib.ByteSeekableByteChannel;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;
import org.apache.commons.lang3.StringUtils;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;

public class ScriptException
extends RuntimeException {
    private volatile ScriptException next;
    private static final AtomicReferenceFieldUpdater<ScriptException, ScriptException> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(ScriptException.class, ScriptException.class, "next");

    public static RuntimeException asRuntime(Throwable e) {
        ScriptException se = ScriptException.wrap(e);
        if (se.getCause() instanceof RuntimeException) {
            return (RuntimeException)se.getCause();
        }
        return se;
    }

    public static ScriptException wrap(Throwable e) {
        Throwable interopException;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof ScriptException) {
            return (ScriptException)e;
        }
        if (e instanceof JSException) {
            DynamicObject errorObject = ((JSException)e).getErrorObject();
            if (errorObject != null) {
                DynamicObjectLibrary lib = DynamicObjectLibrary.getUncached();
                Object dynamicMessage = lib.getOrDefault(errorObject, (Object)"message", (Object)"No message");
                Object dynamicCode = lib.getOrDefault(errorObject, (Object)"code", (Object)"Error");
                if (dynamicMessage != null) {
                    return new ScriptException("Error Code: <" + dynamicCode.toString() + ">, Error Message: " + dynamicMessage.toString());
                }
            }
            return new ScriptException(e.getMessage(), e);
        }
        ScriptException.checkTimeoutException(e);
        if (e instanceof PolyglotException) {
            if (((PolyglotException)e).isHostException()) {
                e = ((PolyglotException)e).asHostException();
            } else {
                if (((PolyglotException)e).getGuestObject() != null) {
                    ScriptException.detailPolyglotException((PolyglotException)e);
                }
                throw new ScriptException(e.getMessage(), e);
            }
        }
        if (e instanceof javax.script.ScriptException && e.getCause() != null && e.getCause() instanceof PolyglotException) {
            e = e.getCause();
        }
        if ((interopException = InternalExceptionCat.consume()) != null) {
            e = interopException;
        }
        if (e instanceof HostException) {
            e = e.getCause() != null ? e.getCause() : ((HostException)e).getOriginal();
        }
        if (e instanceof ScriptException) {
            return (ScriptException)e;
        }
        return new ScriptException(e);
    }

    private static void checkTimeoutException(Throwable e) {
        if (!e.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotEngineImpl$InterruptExecution")) {
            return;
        }
        if (!"Execution got interrupted.".equals(e.getMessage())) {
            return;
        }
        KingScriptEngine engine = KingScriptEngine.getCurrent();
        if (engine == null) {
            return;
        }
        KingScriptEngineImpl engineImpl = engine.unwrap(KingScriptEngineImpl.class);
        if (engineImpl == null) {
            return;
        }
        Object timeoutMessage = engineImpl.getKingScriptContext().getRuntimeAttr("timeout_message_key");
        if (timeoutMessage == null || StringUtils.isBlank((CharSequence)timeoutMessage.toString())) {
            return;
        }
        engineImpl.getKingScriptContext().removeRuntimeAttr("timeout_message_key");
        throw new ScriptException(timeoutMessage.toString());
    }

    private static boolean detailPolyglotException(PolyglotException e) {
        KingScriptEngineImpl engine = KingScriptEngineImpl.getCurrentEngineImpl();
        if (engine == null) {
            return false;
        }
        LibFileSystem libFileSystem = engine.getLibFileSystem();
        try {
            SourceSection sourceLocationFromGust = e.getGuestObject().getSourceLocation();
            if (sourceLocationFromGust == null) {
                return false;
            }
            ByteSeekableByteChannel bc = libFileSystem.newByteChannel(sourceLocationFromGust.getSource().getPath());
            SourceMap sourceMap = bc.getSourceMap();
            if (sourceMap != null) {
                SourceSection targetLocation = e.getSourceLocation();
                SourceMap.Location sourceLocation = sourceMap.getSourceLocation(new SourceMap.Location(targetLocation.getStartLine(), targetLocation.getStartColumn()));
                String errorMessage = ScriptException.generateErrorMessage(bc.getOriginalScript(), sourceLocation.getLineNumber(), sourceLocation.getColumnNumber(), e.getMessage());
                throw new ScriptException(errorMessage, e);
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private static String generateErrorMessage(String sourceCode, int errorLine, int errorColumn, String errorDescription) throws IOException {
        List<String> lines = ScriptException.readLinesFromString(sourceCode);
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Error Message: ").append(errorDescription).append(" (").append(errorLine).append(":").append(errorColumn).append(")\n\n");
        int contextLines = 2;
        int startLine = Math.max(0, errorLine - contextLines - 1);
        int endLine = Math.min(lines.size(), errorLine + contextLines);
        for (int i = startLine; i < endLine; ++i) {
            if (i == errorLine - 1) {
                errorMessage.append("> ");
            } else {
                errorMessage.append("  ");
            }
            errorMessage.append(i + 1).append(" | ").append(lines.get(i)).append("\n");
            if (i != errorLine - 1) continue;
            errorMessage.append("  ");
            for (int j = 0; j < errorColumn; ++j) {
                errorMessage.append(" ");
            }
            errorMessage.append("^\n");
        }
        return errorMessage.toString();
    }

    private static List<String> readLinesFromString(String code) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(code));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public ScriptException() {
    }

    public ScriptException(String message) {
        super(message);
    }

    public ScriptException(String message, Throwable cause) {
        super(message, cause);
    }

    public ScriptException(Throwable cause) {
        super(cause);
    }

    public ScriptException getNextException() {
        return this.next;
    }

    public void setNextException(ScriptException ex) {
        ScriptException current = this;
        while (true) {
            ScriptException next;
            if ((next = current.next) != null) {
                current = next;
                continue;
            }
            if (nextUpdater.compareAndSet(current, null, ex)) {
                return;
            }
            current = current.next;
        }
    }
}

