/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.host;

import com.oracle.truffle.js.runtime.SafeInteger;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import kd.sdk.kingscript.types.Types;

public class HostObjectUtil {
    public static Object getObjectProperty(Object scriptObject, String property) {
        Object javaObj = Types.js2java(scriptObject);
        if (javaObj != null) {
            try {
                if (javaObj instanceof Class) {
                    Field field = ((Class)javaObj).getField(property);
                    return field.get(null);
                }
                Field field = javaObj.getClass().getField(property);
                return field.get(javaObj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object tryToNumber(Object scriptObject) {
        Object object = Types.js2java(scriptObject);
        if (object instanceof Number && !object.getClass().getPackage().getName().equals("java.lang")) {
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).doubleValue();
            }
            if (object instanceof BigInteger) {
                return ((BigInteger)object).longValueExact();
            }
            if (object instanceof AtomicInteger) {
                return ((AtomicInteger)object).intValue();
            }
            if (object instanceof AtomicLong || object instanceof SafeInteger || object instanceof LongAccumulator || object instanceof LongAdder) {
                return ((Number)object).longValue();
            }
            return ((Number)object).doubleValue();
        }
        return null;
    }
}

