/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.LibModuleOfStore;
import kd.sdk.kingscript.lib.tgz.DenpendenciesParse;
import kd.sdk.kingscript.lib.tgz.IndexDTSMerger;
import kd.sdk.kingscript.lib.tgz.TgzVisit;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.Collector;
import kd.sdk.kingscript.monitor.cost.Cost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarLibModuleLoader {
    private static final Logger logger = LoggerFactory.getLogger(JarLibModuleLoader.class);
    public static final String SCRIPT_MODULES_DIR = "script_modules";
    private static final String scriptDirName = "script/";
    private static final String tgzExt = ".tgz";
    private static final List<LibModuleOfStore> modules = new ArrayList<LibModuleOfStore>(32);
    private static final AtomicBoolean loaded = new AtomicBoolean();

    public static List<LibModuleOfStore> loadJarModules() {
        if (loaded.compareAndSet(false, true)) {
            try (Cost cost = Collector.cost("JarLibModuleLoader.loadJarModules", "").logOnClose();){
                JarLibModuleLoader.extractLibModuleInPathJars(SCRIPT_MODULES_DIR);
                String targetDirPath = "script_modules/";
                File root = new File(targetDirPath);
                List<File> packageJsonFiles = JarLibModuleLoader.findPackageJsonFiles(root);
                for (File packageJsonFile : packageJsonFiles) {
                    LibModule module = LibModule.ofStore(packageJsonFile.getParentFile().getAbsolutePath());
                    modules.add((LibModuleOfStore)module);
                }
            }
            Logs.getLogger().info("loadJarModules(" + modules.size() + "): " + modules.stream().map(LibModuleOfStore::getStoreRootPath).collect(Collectors.toList()));
        }
        return modules;
    }

    public static List<LibModule> getModules() {
        return Collections.unmodifiableList(modules);
    }

    public static List<File> findPackageJsonFiles(File directory) {
        ArrayList<File> packageJsonFiles = new ArrayList<File>();
        JarLibModuleLoader.findPackageJsonFilesHelper(directory, packageJsonFiles);
        return packageJsonFiles;
    }

    private static void findPackageJsonFilesHelper(File directory, List<File> packageJsonFiles) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                JarLibModuleLoader.findPackageJsonFilesHelper(file, packageJsonFiles);
                continue;
            }
            if (!file.getName().equals("package.json")) continue;
            packageJsonFiles.add(file);
        }
    }

    public static void deleteDirectory(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void extractLibModuleInPathJars(String targetDirPath) {
        try {
            File targetDir = new File(targetDirPath);
            if (targetDir.exists()) {
                JarLibModuleLoader.deleteDirectory(Paths.get(targetDir.getAbsolutePath(), new String[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        new File(targetDirPath).mkdirs();
        String classpath = System.getProperty("java.class.path");
        String[] classpathElements = classpath.split(System.getProperty("path.separator"));
        HashSet<String> parseModuleSet = new HashSet<String>();
        for (String element : classpathElements) {
            File file = new File(element);
            if (!file.isFile() || !element.endsWith(".jar") && !element.contains("generated-")) continue;
            JarLibModuleLoader.extractJarFile(element, new File(targetDirPath).getAbsolutePath(), false, parseModuleSet);
        }
        IndexDTSMerger.destoryListener();
        TgzVisit.distory();
    }

    private static String[] getShortenCommandJarPaths(JarFile jarFile) throws IOException {
        String value;
        Attributes mainAttributes;
        Manifest manifest;
        String name = jarFile.getName();
        if ((name.matches(".*classpath\\d+.jar") || name.contains("generated-")) && (manifest = jarFile.getManifest()) != null && (mainAttributes = manifest.getMainAttributes()) != null && (value = mainAttributes.getValue("Class-Path")) != null) {
            String[] paths = value.split(" ");
            ArrayList<String> ret = new ArrayList<String>(paths.length);
            for (String item : paths) {
                Path path = Paths.get(URI.create(item));
                File file = path.toFile();
                if (file.isFile()) {
                    String s = file.getCanonicalPath();
                    if (!JarLibModuleLoader.includeJars(s)) continue;
                    ret.add(s);
                    continue;
                }
                ret.add(file.getAbsolutePath());
            }
            return ret.toArray(new String[ret.size()]);
        }
        return null;
    }

    private static boolean includeJars(String jarFilePath) {
        if ((jarFilePath = jarFilePath.replace('\\', '/')).contains("/Temp/classpath") || jarFilePath.contains("/Temp/generated-")) {
            return true;
        }
        return !jarFilePath.contains("sdk-bos-internal-jdk");
    }

    private static void extractJarFile(String jarFilePath, String targetDirPath, boolean nonShortenCommandJar, Set<String> parseModuleSet) {
        if (!JarLibModuleLoader.includeJars(jarFilePath)) {
            return;
        }
        File extractJarFile = new File(jarFilePath);
        if (!extractJarFile.exists()) {
            return;
        }
        if (extractJarFile.isDirectory() && nonShortenCommandJar) {
            DenpendenciesParse.parseLibRepoJar(parseModuleSet, jarFilePath, targetDirPath);
            return;
        }
        if (!extractJarFile.getName().endsWith(".jar")) {
            return;
        }
        try (JarFile jarFile = new JarFile(jarFilePath);){
            String[] jarPaths;
            if (!nonShortenCommandJar && (jarPaths = JarLibModuleLoader.getShortenCommandJarPaths(jarFile)) != null) {
                for (String path : jarPaths) {
                    JarLibModuleLoader.extractJarFile(path, targetDirPath, true, parseModuleSet);
                }
            }
            DenpendenciesParse.parseLibRepoJar(parseModuleSet, jarFilePath, targetDirPath);
        }
        catch (IOException e) {
            logger.error("Try extract script module failed: " + jarFilePath, (Throwable)e);
        }
    }

    public static void main(String[] args) {
        JarLibModuleLoader.loadJarModules();
    }
}

