/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.util.HashMap;
import java.util.Map;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.ScriptPathFormat;

public final class LibFileSystemContext {
    private LibFileSystemContext parent;
    private CurrentLibPath current = new CurrentLibPath();
    private final Map<String, LibModule> pathMap = new HashMap<String, LibModule>();

    public String getPath() {
        return this.current.path;
    }

    public LibModule getLibModule() {
        return this.current.libModule;
    }

    public void setLastLoad(LibModule libModule, String path) {
        path = libModule.getScriptPath(path);
        this.current.libModule = libModule;
        this.current.path = path;
        this.pathMap.put(ScriptPathFormat.format(path), this.current.libModule);
    }

    public void setLastLoadFullPath(String fullPath) {
        this.pathMap.put(fullPath, this.current.libModule);
    }

    public CurrentLibPathCloseable switchTo(String scriptPath) {
        CurrentLibPath last = new CurrentLibPath();
        if (scriptPath == null) {
            last.path = this.current.path;
            last.libModule = this.current.libModule;
        } else {
            last.libModule = this.pathMap.get(scriptPath);
            if (last.libModule == null) {
                last.libModule = this.pathMap.get(ScriptPathFormat.format(scriptPath));
            }
            last.path = scriptPath;
        }
        last.parent = this.current;
        this.current = last;
        return () -> {
            this.current = this.current.parent;
        };
    }

    public String toString() {
        return this.current.path == null ? "" : this.current.path;
    }

    private static class CurrentLibPath {
        CurrentLibPath parent;
        String path;
        LibModule libModule;

        private CurrentLibPath() {
        }
    }

    public static interface CurrentLibPathCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

