/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class PathResolver {
    final String moduleName;
    final String scriptPath;
    private static final Map<String, PathResolver> pathMap = new ConcurrentHashMap<String, PathResolver>();

    private PathResolver(String moduleName, String scriptPath) {
        this.moduleName = moduleName;
        this.scriptPath = scriptPath;
    }

    public static PathResolver resolve(String path, Set<String> moduleNameSet) {
        PathResolver ret = pathMap.get(path);
        if (ret == null) {
            ret = pathMap.computeIfAbsent(path, k -> PathResolver.doResolve(k, moduleNameSet));
        }
        return ret;
    }

    private static PathResolver doResolve(String path, Set<String> moduleNameSet) {
        String scriptPath;
        String moduleName;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.startsWith("./")) {
            return new PathResolver("", path);
        }
        for (String moduleName2 : moduleNameSet) {
            if (!path.startsWith(moduleName2 + '/')) continue;
            return new PathResolver(moduleName2, path.substring(moduleName2.length() + 1));
        }
        Path pp = Paths.get(path, new String[0]);
        int nameCount = pp.getNameCount();
        if (nameCount < 2) {
            return new PathResolver("", path);
        }
        if (nameCount >= 2 && path.charAt(0) == '@') {
            moduleName = pp.subpath(0, 2).toString().replace('\\', '/');
            scriptPath = nameCount > 2 ? pp.subpath(2, nameCount).toString().replace('\\', '/') : "";
        } else {
            moduleName = pp.getName(0).toString();
            scriptPath = pp.subpath(1, nameCount).toString().replace('\\', '/');
        }
        return new PathResolver(moduleName, scriptPath);
    }
}

