/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class ScriptInfo {
    private final String version;
    private final String script;
    private final String compileScript;
    private final String sourceMap;
    private final String isv;
    private final String scriptType;
    private static final Set<String> NON_ISV_KEYWORDS = new HashSet<String>(4);

    public ScriptInfo(String script) {
        this(script, "V" + script.length() + '_' + script.hashCode());
    }

    public ScriptInfo(String script, String version) {
        this(script, version, null);
    }

    public ScriptInfo(String script, String version, String isv) {
        this(script, version, isv, null, null);
    }

    public ScriptInfo(String script, String version, String isv, String compileScript, String sourceMap) {
        this(script, version, isv, null, null, null);
    }

    public ScriptInfo(String script, String version, String isv, String compileScript, String sourceMap, String scriptType) {
        this.script = script;
        this.version = version;
        this.isv = isv;
        this.sourceMap = sourceMap;
        this.compileScript = compileScript;
        this.scriptType = scriptType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScript() {
        return this.script;
    }

    public String getCompileScript() {
        return this.compileScript;
    }

    public String getSourceMap() {
        return this.sourceMap;
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public String getIsv() {
        return this.isv;
    }

    public boolean isISV() {
        if (StringUtils.isBlank((CharSequence)this.isv)) {
            return false;
        }
        return !NON_ISV_KEYWORDS.contains(this.isv);
    }

    public String toString() {
        return "ScriptInfo{script='" + this.script + '\'' + ", version='" + this.version + '\'' + ", isv=" + this.isv + '}';
    }

    static {
        NON_ISV_KEYWORDS.add("kingdee");
        NON_ISV_KEYWORDS.add("kdtest");
    }
}

