/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.util.Collection;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.LibModule;

public final class ScriptPathFormat {
    private static final String script_modules_dir = "script_modules/";
    private static final int script_modules_dir_len = "script_modules/".length();
    private static final String project_src_script_path = "src/script/";
    private static final int project_src_script_path_len = "src/script/".length();

    public static String format(String scriptPath) {
        return ScriptPathFormat.format(scriptPath, null);
    }

    public static String format(String scriptPath, Collection<LibModule> libModules) {
        if (scriptPath == null) {
            throw new ScriptException("ScriptPathFormat: scriptPath can't be null");
        }
        int p = (scriptPath = scriptPath.replace('\\', '/')).indexOf("node_modules/");
        if (p != -1) {
            scriptPath = scriptPath.substring(p + 12);
        } else {
            p = scriptPath.indexOf(script_modules_dir);
            if (p != -1) {
                scriptPath = scriptPath.substring(p + script_modules_dir_len);
            } else {
                p = scriptPath.indexOf(project_src_script_path);
                if (p != -1) {
                    boolean findProjectModule = false;
                    if (libModules != null) {
                        for (LibModule libModule : libModules) {
                            if (!libModule.isDevMode() || libModule.tryLookupPath(scriptPath) == null) continue;
                            findProjectModule = true;
                            scriptPath = libModule.getName() + '/' + scriptPath.substring(p + project_src_script_path_len);
                            break;
                        }
                    }
                    if (!findProjectModule) {
                        scriptPath = scriptPath.substring(p);
                    }
                }
            }
        }
        if (scriptPath.startsWith("/@")) {
            scriptPath = scriptPath.substring(1);
        }
        if (scriptPath.endsWith(".c")) {
            scriptPath = scriptPath.substring(0, scriptPath.length() - ".c".length());
        } else if (scriptPath.endsWith(".c.min")) {
            scriptPath = scriptPath.substring(0, scriptPath.length() - ".c.min".length());
        }
        if (scriptPath.endsWith("/index.ts") || scriptPath.endsWith("/index.js")) {
            scriptPath = scriptPath.substring(0, scriptPath.length() - 9);
        } else if (scriptPath.endsWith("/index")) {
            scriptPath = scriptPath.substring(0, scriptPath.length() - 6);
        } else if (scriptPath.endsWith(".ts") || scriptPath.endsWith(".js")) {
            scriptPath = scriptPath.substring(0, scriptPath.length() - 3);
        }
        return scriptPath;
    }
}

