/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.crypto;

import java.util.Base64;
import kd.sdk.kingscript.lib.crypto.AES;
import kd.sdk.kingscript.lib.crypto.AESPool;
import kd.sdk.kingscript.lib.crypto.CryptoService;

public class DefaultCryptoService
implements CryptoService {
    static final DefaultCryptoService INSTANCE = new DefaultCryptoService("default");
    private final String name;

    private DefaultCryptoService(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String encrypt(String script) {
        AES aes = AESPool.getAny();
        String content = aes.encrypt(script);
        AESPool.release(aes);
        byte[] key = aes.getKey();
        byte[] iv = aes.getIV();
        byte[] bs = new byte[key.length + iv.length];
        System.arraycopy(key, 0, bs, 0, key.length);
        System.arraycopy(iv, 0, bs, key.length, iv.length);
        String header = Base64.getEncoder().encodeToString(bs);
        return header + '\n' + content;
    }

    @Override
    public String decrypt(String encryptedScript) {
        int p = encryptedScript.indexOf(10);
        String header = encryptedScript.substring(0, p);
        String content = encryptedScript.substring(p + 1);
        byte[] bs = Base64.getDecoder().decode(header);
        byte[] key = new byte[32];
        byte[] iv = new byte[12];
        System.arraycopy(bs, 0, key, 0, key.length);
        System.arraycopy(bs, key.length, iv, 0, iv.length);
        AES aes = AESPool.get(key, iv);
        String ret = aes.decrypt(content);
        AESPool.release(aes);
        return ret;
    }
}

