/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.crypto.meta;

import java.util.HashMap;
import java.util.Map;
import kd.sdk.kingscript.lib.crypto.AES;
import kd.sdk.kingscript.lib.crypto.AESPool;
import kd.sdk.kingscript.lib.crypto.meta.MetaCrypto;

abstract class AbstractMetaCrypto
implements MetaCrypto {
    protected static final int VERSION_LEN = 8;
    protected static final int MAGIC_LEN = 24;
    protected static final int KEY_LEN = 32;
    protected static final int IV_LEN = 12;
    protected static final int HEADER_LEN = 76;
    private static Map<Integer, byte[]> vbMap = new HashMap<Integer, byte[]>();
    private final byte[] magic = this.createMagic();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getVersionBytes(int version) {
        byte[] ret = vbMap.get(version);
        if (ret == null) {
            Map<Integer, byte[]> map = vbMap;
            synchronized (map) {
                ret = vbMap.get(version);
                if (ret == null) {
                    int j = 0;
                    ret = new byte[8];
                    for (int i = version; i > 0; --i) {
                        int n = j++;
                        ret[n] = (byte)(ret[n] + 1);
                        if (j < 8) continue;
                        j = 0;
                    }
                    vbMap.put(version, ret);
                }
            }
        }
        return ret;
    }

    protected static int getVersion(byte[] bs) {
        int ret = 0;
        for (byte b : bs) {
            ret += b;
        }
        return ret;
    }

    AbstractMetaCrypto() {
        assert (this.magic.length == 24);
    }

    @Override
    public abstract int getVersion();

    protected abstract byte[] createMagic();

    protected AES acquire(byte[] bs) {
        assert (this.getVersion() == AbstractMetaCrypto.getVersion(bs));
        byte[] key = new byte[32];
        byte[] iv = new byte[12];
        int from = 32;
        System.arraycopy(bs, from, key, 0, 32);
        System.arraycopy(bs, from + 32, iv, 0, 12);
        return AESPool.get(key, iv);
    }

    protected void release(AES aes) {
        AESPool.release(aes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] content) {
        AES aes = AESPool.getAny();
        try {
            byte[] encryptedContent = aes.encrypt(content);
            byte[] ret = new byte[encryptedContent.length + 76];
            byte[] version = AbstractMetaCrypto.getVersionBytes(this.getVersion());
            System.arraycopy(version, 0, ret, 0, 8);
            System.arraycopy(this.magic, 0, ret, 8, 24);
            System.arraycopy(aes.getKey(), 0, ret, 32, 32);
            System.arraycopy(aes.getIV(), 0, ret, 64, 12);
            System.arraycopy(encryptedContent, 0, ret, 76, encryptedContent.length);
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            this.release(aes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] bs) {
        AES aes = this.acquire(bs);
        try {
            byte[] content = new byte[bs.length - 76];
            System.arraycopy(bs, 76, content, 0, content.length);
            byte[] byArray = aes.decrypt(content);
            return byArray;
        }
        finally {
            this.release(aes);
        }
    }
}

