/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.store;

import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.store.ScriptDBStore;
import kd.sdk.kingscript.lib.store.ScriptFileStore;
import kd.sdk.kingscript.lib.store.ScriptStoreType;

public interface ScriptStore {
    @ConfigurableItem(desc="kingscript store type")
    public static final String CONFIG_STORE_TYPE = "kingscript.store.type";
    @ConfigurableItem(desc="kingscript db store type")
    public static final String CONFIG_STORE_TYPE_DB_CLASS = "kingscript.store.type.db.class";

    default public boolean isFileStore() {
        return false;
    }

    default public boolean exists(String path) {
        return this.exists(new String[]{path}) == 0;
    }

    public int exists(String ... var1);

    public ScriptInfo load(String var1);

    public Map<String, List<String>> listModuleTypes(String ... var1);

    public static ScriptStore create() {
        if (ScriptStoreType.DB.name().equals(System.getProperty(CONFIG_STORE_TYPE, ScriptStoreType.FILE.name()))) {
            String cls = System.getProperty(CONFIG_STORE_TYPE_DB_CLASS);
            if (cls != null && !cls.isEmpty()) {
                try {
                    return (ScriptStore)Class.forName(cls).newInstance();
                }
                catch (Exception e) {
                    throw new ScriptException(e);
                }
            }
            return new ScriptDBStore();
        }
        return new ScriptFileStore();
    }
}

