/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MergerBuilder {
    private String parentModuleMark;
    private String parentModuleName;
    private List<String> tsDepenList = new ArrayList<String>();
    public Map<String, List<String>> mergerNameSpaceClassMap = new TreeMap<String, List<String>>();
    public Map<String, Long> mergerClassBuildTimeMap = new HashMap<String, Long>();
    public Map<String, List<String>> mergerClassDataMap = new TreeMap<String, List<String>>();
    public Map<String, String> mergerReferenceDataMap = new TreeMap<String, String>();
    private static List<String> interfaceSuffixNameList = new ArrayList<String>();
    private String namespaceSpaces = "        ";

    public void setParentModuleMark(String parentModuleMark) {
        this.parentModuleMark = parentModuleMark;
    }

    public void setParentModuleName(String parentModuleName) {
        this.parentModuleName = parentModuleName;
    }

    public void setTsDepenList(List<String> tsDepenList) {
        this.tsDepenList = tsDepenList;
    }

    public void mergerClass(String namespacePath, Set<String> namespaceClassSet, Map<String, String> namespaceClassDataMap, Set<String> moduleClassSet, Long buildTime) {
        if (null == namespaceClassSet || namespaceClassSet.size() <= 0) {
            return;
        }
        namespaceClassSet.forEach(data -> {
            String clazzPath = namespacePath + "##" + data;
            String clazzUrl = namespacePath.replace("$::", "") + "." + data;
            Long mergerBuildTime = this.mergerClassBuildTimeMap.get(clazzPath);
            if (null == mergerBuildTime) {
                if (moduleClassSet.contains(clazzUrl)) {
                    this.mergerAddClass(clazzPath, (String)data, namespaceClassDataMap);
                    this.mergerClassBuildTimeMap.put(clazzPath, -1L);
                } else {
                    this.mergerAddClass(clazzPath, (String)data, namespaceClassDataMap);
                    this.mergerClassBuildTimeMap.put(clazzPath, buildTime);
                }
                List clazzPathList = this.mergerNameSpaceClassMap.computeIfAbsent(namespacePath, k -> new ArrayList());
                clazzPathList.add(clazzPath);
            } else {
                if (mergerBuildTime.equals(-1L)) {
                    return;
                }
                if (moduleClassSet.contains(clazzUrl)) {
                    this.mergerDeleteClass(clazzPath);
                    this.mergerAddClass(clazzPath, (String)data, namespaceClassDataMap);
                    this.mergerClassBuildTimeMap.put(clazzPath, -1L);
                    return;
                }
                if (buildTime > mergerBuildTime) {
                    this.mergerDeleteClass(clazzPath);
                    this.mergerAddClass(clazzPath, (String)data, namespaceClassDataMap);
                    this.mergerClassBuildTimeMap.put(clazzPath, buildTime);
                }
            }
        });
    }

    private void mergerAddClass(String clazzPath, String clazzName, Map<String, String> namespaceClassDataMap) {
        if (null != interfaceSuffixNameList && interfaceSuffixNameList.size() > 0) {
            interfaceSuffixNameList.forEach(data -> {
                String key = clazzName + data;
                String member = (String)namespaceClassDataMap.get(key);
                if (null == member) {
                    return;
                }
                List dataList = this.mergerClassDataMap.computeIfAbsent(clazzPath, k -> new ArrayList());
                dataList.add(member);
            });
        }
        String member = namespaceClassDataMap.get(clazzName);
        List dataList = this.mergerClassDataMap.computeIfAbsent(clazzPath, k -> new ArrayList());
        dataList.add(member);
    }

    private void mergerDeleteClass(String clazzPath) {
        this.mergerClassDataMap.remove(clazzPath);
    }

    public void write(String filePath) {
        if (null == this.mergerNameSpaceClassMap || this.mergerNameSpaceClassMap.size() == 0) {
            return;
        }
        if (null == this.mergerClassDataMap || this.mergerClassDataMap.size() == 0) {
            return;
        }
        try (FileWriter writer = new FileWriter(Paths.get(filePath, new String[0]).toFile());){
            if (this.tsDepenList != null && this.tsDepenList.size() >= 1) {
                this.tsDepenList.forEach(data -> {
                    try {
                        String[] strArr = data.split("/");
                        if (strArr.length != 2) {
                            return;
                        }
                        if (strArr[0].equals(this.parentModuleMark) && strArr[1].equals(this.parentModuleName)) {
                            return;
                        }
                        writer.write("/// <reference types=\"../../");
                        writer.write((String)data);
                        writer.write("\" />");
                        writer.write(System.lineSeparator());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            writer.write("declare global {");
            writer.write(System.lineSeparator());
            writer.write("  ");
            writer.write("  ");
            writer.write("namespace $ {");
            writer.write(System.lineSeparator());
            this.mergerNameSpaceClassMap.entrySet().forEach(data -> {
                String key = (String)data.getKey();
                List clazzPathList = (List)data.getValue();
                if (null == clazzPathList || clazzPathList.size() == 0) {
                    return;
                }
                String[] npArr = key.split("::");
                try {
                    writer.write(this.namespaceSpaces);
                    writer.write("namespace ");
                    writer.write(npArr[1]);
                    writer.write("{");
                    writer.write(System.lineSeparator());
                    writer.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                clazzPathList.forEach(clazzPath -> {
                    List<String> clazzDataList = this.mergerClassDataMap.get(clazzPath);
                    clazzDataList.forEach(clazzData -> {
                        try {
                            writer.write((String)clazzData);
                            writer.write(System.lineSeparator());
                            writer.flush();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                });
                try {
                    writer.write(this.namespaceSpaces);
                    writer.write("}");
                    writer.write(System.lineSeparator());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            writer.write("  ");
            writer.write("  ");
            writer.write("}");
            writer.write(System.lineSeparator());
            writer.write("}");
            writer.write(System.lineSeparator());
            writer.write("export {};");
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mergerReference(String typeName, String data) {
        this.mergerReferenceDataMap.put(typeName, data);
    }

    static {
        interfaceSuffixNameList.add("_S");
        interfaceSuffixNameList.add("_ST");
        interfaceSuffixNameList.add("_C");
        interfaceSuffixNameList.add("$");
        interfaceSuffixNameList.add("_T");
    }
}

