/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import com.alibaba.fastjson.JSONObject;
import java.io.FileWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class PackageConfig {
    public static final String PACKAGE_CONFIG = "package.json";
    private String subModule;
    private String userName;
    private String parentModuleMark;
    private LocalDateTime buildTime;
    public static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private String defaultParentModuleMark = "@default";

    public PackageConfig() {
        this.userName = System.getProperty("user.name");
    }

    public PackageConfig(String parentModuleMark, String subModule, LocalDateTime buildTime) {
        this.subModule = subModule;
        this.userName = System.getProperty("kingdee");
        this.buildTime = buildTime;
        this.parentModuleMark = StringUtils.isBlank((CharSequence)parentModuleMark) ? this.defaultParentModuleMark : parentModuleMark;
    }

    public JSONObject buildConfig() {
        JSONObject config = new JSONObject();
        config.put("name", (Object)(StringUtils.isBlank((CharSequence)this.subModule) ? this.parentModuleMark + "/default" : this.parentModuleMark + "/" + this.subModule));
        config.put("version", (Object)"1.0.0");
        config.put("description", (Object)"");
        config.put("main", (Object)"index.js");
        config.put("types", (Object)"index_reference.d.ts");
        ArrayList<String> filesList = new ArrayList<String>();
        filesList.add("**/*");
        config.put("files", filesList);
        JSONObject exportsJson = new JSONObject();
        exportsJson.put(".", (Object)"index.d.ts");
        config.put("exports", (Object)exportsJson);
        JSONObject scriptsJson = new JSONObject();
        config.put("scripts", (Object)scriptsJson);
        ArrayList<String> keywordsList = new ArrayList<String>();
        keywordsList.add("kingdee");
        keywordsList.add("cosmic");
        keywordsList.add("sdk");
        keywordsList.add("bos");
        keywordsList.add("framework");
        config.put("keywords", keywordsList);
        config.put("author", (Object)this.userName);
        config.put("license", (Object)"MIT");
        JSONObject dependenciesJson = new JSONObject();
        config.put("dependencies", (Object)dependenciesJson);
        config.put("buildTime", (Object)formatter.format(this.buildTime));
        return config;
    }

    public void write(String path, JSONObject config) {
        try (FileWriter converterPackAgeConfigWriter = new FileWriter(path);){
            converterPackAgeConfigWriter.write(config.toJSONString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
    }
}

