/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import kd.sdk.kingscript.lib.tgz.DependenciesTSEntity;
import kd.sdk.kingscript.lib.tgz.SDKOutConfigEnum;
import kd.sdk.kingscript.lib.tgz.TSMerger;
import kd.sdk.kingscript.lib.tgz.TgzUtil;
import kd.sdk.kingscript.lib.tgz.TgzVisit;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.lang3.StringUtils;

public class ParseTsTgz {
    public static void extractTgzFile(String libPathLeaf, String tgzFilePath, DependenciesTSEntity depenTSEntity) {
        String entryName = new File(tgzFilePath).getName();
        String moduleName = null;
        if (StringUtils.isEmpty((CharSequence)depenTSEntity.getParentModuleName())) {
            moduleName = entryName.substring(0, entryName.lastIndexOf(45)).replace("+", File.separator);
        } else {
            String moduleNameSub = entryName.substring(0, entryName.lastIndexOf(45));
            String[] strArr = moduleNameSub.split("\\+");
            moduleName = strArr[0] + File.separator + depenTSEntity.getParentModuleName();
        }
        ParseTsTgz.extractTgz(tgzFilePath, libPathLeaf, moduleName, depenTSEntity);
        new File(tgzFilePath).delete();
    }

    public static List<String> loadConfigByPath(String configPath) {
        ArrayList<String> dataList = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(Paths.get(configPath, new String[0]).toFile()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("") || line.trim().startsWith("#")) continue;
                dataList.add(line);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return dataList;
    }

    private static void extractTgz(String tgzFilePath, String destDirPath, String moduleName, DependenciesTSEntity depenTSEntity) {
        try {
            Files.createDirectories(Paths.get(destDirPath, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String key = depenTSEntity.getParentModuleMark() + "::" + depenTSEntity.getParentModuleName() + "::" + depenTSEntity.getSubModuleName();
        if (StringUtils.isEmpty((CharSequence)depenTSEntity.getParentModuleName()) || key.equals("@cosmic::bos-script::sdk-bos-kingscript") || key.equals("@cosmic::bos-util::sdk-bos-util") || key.equals("@cosmic::bos-framework::sdk-bos-framework") || key.equals("@cosmic::bos-test::sdk-bos-test") || "NATIVE_TS".equals(depenTSEntity.getTsType())) {
            ParseTsTgz.extractTgzOnlyCopy(tgzFilePath, destDirPath, moduleName);
            return;
        }
        ParseTsTgz.extractTgzBefore(tgzFilePath, destDirPath, moduleName, depenTSEntity);
        ParseTsTgz.extractTgzAfter(tgzFilePath, destDirPath, moduleName, depenTSEntity);
    }

    private static void extractTgzBefore(String tgzFilePath, String destDirPath, String moduleName, final DependenciesTSEntity depenTSEntity) {
        TgzVisit tgzVisit = new TgzVisit(){

            @Override
            public boolean visitSkip(File file, TarArchiveInputStream tarIn) {
                return !file.getName().equals("package.json") && !file.getName().equals(SDKOutConfigEnum.ALL_JAVA_CLASS_CONFIG.configName) && !file.getName().equals(SDKOutConfigEnum.EXPORT_TS_TYPE_CONFIG.configName);
            }

            @Override
            public boolean visitPackage(File file, TarArchiveInputStream tarIn) {
                try {
                    TSMerger.mergerPackageConfig(depenTSEntity, tarIn, file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }

            @Override
            public boolean visitAllClassConfig(File file, TarArchiveInputStream tarIn) {
                try {
                    this.copyFile(file, tarIn);
                    List<String> allClassList = ParseTsTgz.loadConfigByPath(file.getAbsolutePath());
                    depenTSEntity.setAllClassList(allClassList);
                    Files.deleteIfExists(Paths.get(file.getCanonicalPath(), new String[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }

            @Override
            public boolean visitExportConfig(File file, TarArchiveInputStream tarIn) {
                try {
                    this.copyFile(file, tarIn);
                    List<String> exportClassList = ParseTsTgz.loadConfigByPath(file.getAbsolutePath());
                    depenTSEntity.setExportClassList(exportClassList);
                    Files.deleteIfExists(Paths.get(file.getCanonicalPath(), new String[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
        };
        TgzUtil.build(tgzFilePath, destDirPath, moduleName).iterator(tgzVisit);
    }

    private static void extractTgzAfter(String tgzFilePath, String destDirPath, String moduleName, final DependenciesTSEntity depenTSEntity) {
        TgzVisit tgzVisit = new TgzVisit(){

            @Override
            public boolean visitSkip(File file, TarArchiveInputStream tarIn) {
                return ParseTsTgz.getSkipMark(file);
            }

            @Override
            public boolean visitIndexDTS(File file, TarArchiveInputStream tarIn) {
                TSMerger.mergerIndexDTs(depenTSEntity, tarIn, file);
                return true;
            }

            @Override
            public boolean visitIndexJS(File file, TarArchiveInputStream tarIn) {
                this.copyFile(file, tarIn);
                return true;
            }

            @Override
            public boolean visitFileToLocalAppendConditional(File file) {
                return file.getName().endsWith(".js") || file.getName().endsWith(".d.ts") || file.getName().equals(SDKOutConfigEnum.DECLARE_TS_TYPE_CONFIG.configName) || file.getName().equals(SDKOutConfigEnum.EXPORT_TS_TYPE_CONFIG.configName) || file.getName().equals(SDKOutConfigEnum.AUTO_REPLACE_ANY_CONFIG.configName) || file.getName().equals(SDKOutConfigEnum.AUTO_REPLACE_ANY_JDK_CONFIG.configName);
            }
        };
        TgzUtil.build(tgzFilePath, destDirPath, moduleName).iterator(tgzVisit);
    }

    private static boolean getSkipMark(File file) {
        return file.getName().equals("package.json") || file.getName().equals(SDKOutConfigEnum.ALL_JAVA_CLASS_CONFIG.configName);
    }

    private static void extractTgzOnlyCopy(String tgzFilePath, String destDirPath, String moduleName) {
        TgzVisit tgzVisit = new TgzVisit(){

            @Override
            public boolean visitPackage(File file, TarArchiveInputStream tarIn) {
                this.copyFile(file, tarIn);
                String packageStr = null;
                JSONObject packageJson = null;
                try {
                    packageStr = file.exists() ? new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]))) : "{}";
                    packageJson = JSONObject.parseObject((String)packageStr);
                    packageJson.put("types", (Object)"index_reference.d.ts");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try (FileWriter packAgeConfigWriter = new FileWriter(new File(file.getAbsolutePath()));){
                    String formatJson = JSON.toJSONString((Object)packageJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
                    packAgeConfigWriter.write(formatJson);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return true;
            }
        };
        TgzUtil.build(tgzFilePath, destDirPath, moduleName).iterator(tgzVisit);
    }
}

