/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.sdk.kingscript.lib.tgz.DependenciesTSEntity;
import kd.sdk.kingscript.lib.tgz.IndexDTSMerger;
import kd.sdk.kingscript.lib.tgz.PackageConfig;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class TSMerger {
    private static final String PACKAGE_SET_CONFIG = "package_config.properties";

    public static void mergerPackageConfig(DependenciesTSEntity depenTSEntity, TarArchiveInputStream tarIn, File newFile) throws IOException {
        JSONObject subDepenJson;
        if (!newFile.exists()) {
            PackageConfig packageConfig = new PackageConfig(depenTSEntity.getParentModuleMark(), depenTSEntity.getParentModuleName(), LocalDateTime.of(1970, 1, 1, 0, 0, 0));
            packageConfig.write(newFile.getAbsolutePath(), packageConfig.buildConfig());
        }
        long nanoNum = LocalDateTime.now().getNano();
        File packageSubFile = new File(newFile.getParent() + File.separator + depenTSEntity.getSubModuleName() + "_" + nanoNum + ".json");
        new File(packageSubFile.getParent()).mkdirs();
        try (FileOutputStream fos = new FileOutputStream(packageSubFile);){
            IOUtils.copy((InputStream)tarIn, (OutputStream)fos);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String rootPackageStr = new String(Files.readAllBytes(Paths.get(newFile.getAbsolutePath(), new String[0])));
        JSONObject rootPackageJson = JSONObject.parseObject((String)rootPackageStr);
        String subPackageStr = new String(Files.readAllBytes(Paths.get(packageSubFile.getAbsolutePath(), new String[0])));
        JSONObject sunPackageJson = JSONObject.parseObject((String)subPackageStr);
        if (!packageSubFile.delete()) {
            throw new RuntimeException("delete packageconfig.json error: " + packageSubFile.getAbsolutePath());
        }
        String rootDepenStr = rootPackageJson.getString("dependencies");
        JSONObject rootDepenJson = StringUtils.isEmpty((CharSequence)rootDepenStr) ? new JSONObject() : JSONObject.parseObject((String)rootDepenStr);
        String subDepenStr = sunPackageJson.getString("dependencies");
        if (!StringUtils.isEmpty((CharSequence)subDepenStr) && null != (subDepenJson = JSONObject.parseObject((String)subDepenStr)) && subDepenJson.size() > 0) {
            Set depenKeySet = subDepenJson.keySet();
            depenKeySet.stream().forEach(key -> {
                if (key.equals(depenTSEntity.getParentModuleMark() + "/" + depenTSEntity.getParentModuleName())) {
                    return;
                }
                rootDepenJson.put(key, (Object)subDepenJson.getString(key));
            });
        }
        ArrayList<String> tsDepenList = new ArrayList<String>(rootDepenJson.keySet());
        depenTSEntity.setTsDepenList(tsDepenList);
        String rootBuildTimeStr = rootPackageJson.getString("buildTime");
        LocalDateTime rootBuildTime = LocalDateTime.parse(rootBuildTimeStr, PackageConfig.formatter);
        String subBuildTimeStr = sunPackageJson.getString("buildTime");
        if (null != subBuildTimeStr) {
            LocalDateTime subBuildTime = LocalDateTime.parse(subBuildTimeStr, PackageConfig.formatter);
            depenTSEntity.setBuildTime(subBuildTime);
            if (subBuildTime.isAfter(rootBuildTime)) {
                rootPackageJson.put("buildTime", (Object)subBuildTimeStr);
            }
        }
        rootPackageJson.put("dependencies", (Object)rootDepenJson);
        try (FileWriter converterPackAgeConfigWriter = new FileWriter(newFile.getAbsolutePath());){
            String formatJson = JSON.toJSONString((Object)rootPackageJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            converterPackAgeConfigWriter.write(formatJson);
            File packageSetConfigFile = new File(newFile.getParent() + File.separator + PACKAGE_SET_CONFIG);
            if (!packageSetConfigFile.exists() && !packageSetConfigFile.createNewFile()) {
                throw new RuntimeException("create new file error!");
            }
            String writeStr = depenTSEntity.getSubModuleName() + System.getProperty("line.separator");
            Files.write(Paths.get(packageSetConfigFile.getAbsolutePath(), new String[0]), writeStr.getBytes(), StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            throw new RemoteException();
        }
    }

    public static void mergerIndexDTs(DependenciesTSEntity depenTSEntity, TarArchiveInputStream tarIn, File newFile) {
        String tempIndexPath = newFile.getParent() + File.separator + newFile.getName() + ".temp";
        try (FileOutputStream fos = new FileOutputStream(new File(tempIndexPath));){
            IOUtils.copy((InputStream)tarIn, (OutputStream)fos);
            IndexDTSMerger indexDTSMerger = new IndexDTSMerger(newFile, depenTSEntity);
            Long buildTime = depenTSEntity.getBuildTime() == null ? 1L : (long)depenTSEntity.getBuildTime().getNano();
            HashSet<String> allClassSet = new HashSet<String>();
            if (null != depenTSEntity.getAllClassList()) {
                allClassSet.addAll(depenTSEntity.getAllClassList());
            }
            indexDTSMerger.merger(depenTSEntity, tempIndexPath, buildTime, allClassSet);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            Files.deleteIfExists(Paths.get(tempIndexPath, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDepeModule(String line) {
        String regex = "types\\s*=\\s*\"\\s*([^\"]+)\\s*\"";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }
}

