/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import kd.sdk.kingscript.lib.tgz.TgzVisit;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TgzUtil {
    private String tgzPath;
    private String destDirPath;
    private String moduleName;

    public String getTgzPath() {
        return this.tgzPath;
    }

    public void setTgzPath(String tgzPath) {
        this.tgzPath = tgzPath;
    }

    public String getDestDirPath() {
        return this.destDirPath;
    }

    public void setDestDirPath(String destDirPath) {
        this.destDirPath = destDirPath;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public static TgzUtil build(String tgzPath, String destDirPath, String moduleName) {
        TgzUtil tgzUtil = new TgzUtil();
        tgzUtil.setTgzPath(tgzPath);
        tgzUtil.setDestDirPath(destDirPath);
        tgzUtil.setModuleName(moduleName);
        return tgzUtil;
    }

    public void iterator(TgzVisit tgzVisit) {
        String path = this.getTgzPath();
        if (null == path || path.trim().isEmpty()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(new File(path));
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GZIPInputStream(fis));){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                File newFile = TgzUtil.getFile(this.getDestDirPath(), this.getModuleName(), entry);
                if (entry.isDirectory()) continue;
                String parentModulePath = this.destDirPath + File.separator + this.getModuleName();
                tgzVisit.visitFile(parentModulePath, newFile, tarIn);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static File getFile(String destDirPath, String moduleName, TarArchiveEntry entry) {
        File newFile;
        String fileName = entry.getName();
        if (fileName.startsWith("package")) {
            fileName = moduleName + fileName.substring(7);
        }
        if ((newFile = new File(destDirPath + File.separator + fileName)).isDirectory()) {
            newFile.mkdirs();
        } else {
            new File(newFile.getParent()).mkdirs();
        }
        return newFile;
    }
}

