/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.sdk.kingscript.lib.tgz.SDKOutConfigEnum;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TgzVisit {
    public static Map<String, HashSet<String>> dtsMap = new HashMap<String, HashSet<String>>();

    public void visitFile(String parentModulePath, File file, TarArchiveInputStream tarIn) {
        this.collectDTS(parentModulePath, file);
        if (this.visitSkip(file, tarIn)) {
            return;
        }
        if (file.getName().equals("package.json") && this.visitPackage(file, tarIn)) {
            return;
        }
        if (file.getName().equals(SDKOutConfigEnum.ALL_JAVA_CLASS_CONFIG.configName) && this.visitAllClassConfig(file, tarIn)) {
            return;
        }
        if (file.getName().equals(SDKOutConfigEnum.EXPORT_TS_TYPE_CONFIG.configName) && this.visitExportConfig(file, tarIn)) {
            return;
        }
        if (file.getName().equals("index.d.ts") && this.visitIndexDTS(file, tarIn)) {
            return;
        }
        if (file.getName().equals("index.js") && this.visitIndexJS(file, tarIn)) {
            return;
        }
        if (this.visitFileToLocalAppendConditional(file)) {
            this.copyFileAppend(file, tarIn);
            return;
        }
        this.copyFile(file, tarIn);
    }

    public boolean visitSkip(File file, TarArchiveInputStream tarIn) {
        return false;
    }

    public boolean visitPackage(File file, TarArchiveInputStream tarIn) {
        return false;
    }

    public boolean visitAllClassConfig(File file, TarArchiveInputStream tarIn) {
        return false;
    }

    public boolean visitExportConfig(File file, TarArchiveInputStream tarIn) {
        return false;
    }

    public boolean visitIndexDTS(File file, TarArchiveInputStream tarIn) {
        return false;
    }

    public boolean visitIndexJS(File file, TarArchiveInputStream tarIn) {
        return false;
    }

    public boolean visitFileToLocalAppendConditional(File file) {
        return false;
    }

    protected void copyFile(File file, TarArchiveInputStream tarIn) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)tarIn, (OutputStream)fos);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void copyFileAppend(File file, TarArchiveInputStream tarIn) {
        try (FileOutputStream fos = new FileOutputStream(file, true);){
            IOUtils.copy((InputStream)tarIn, (OutputStream)fos);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void collectDTS(String parentModulePath, File file) {
        if (!file.getName().endsWith(".d.ts")) {
            return;
        }
        try {
            String dtsPath = file.getCanonicalPath().replace(parentModulePath, "");
            dtsPath = dtsPath.replace("\\", "/");
            dtsPath = dtsPath.replace(".d.ts", "");
            dtsPath = "." + dtsPath;
            HashSet dtsSet = dtsMap.computeIfAbsent(parentModulePath + File.separator + "index_reference.d.ts", k -> new HashSet());
            dtsSet.add(dtsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void distory() {
        if (null != dtsMap) {
            dtsMap.forEach((key, value) -> TgzVisit.writeReferenceFile(key, value));
            dtsMap.clear();
        }
    }

    public static void writeReferenceFile(String indexdtsDTSPath, Set<String> dtsSet) {
        if (null == indexdtsDTSPath || indexdtsDTSPath.isEmpty()) {
            return;
        }
        if (null == dtsSet || dtsSet.size() == 0) {
            return;
        }
        try (FileWriter tmpWriter = new FileWriter(indexdtsDTSPath);){
            dtsSet.forEach(data -> {
                try {
                    tmpWriter.write("/// <reference types=\"");
                    tmpWriter.write((String)data);
                    tmpWriter.write("\" />");
                    tmpWriter.write(System.lineSeparator());
                    tmpWriter.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

