/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.version;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.engine.ModuleExports;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.lib.version.LocalMemoryScriptVersionStore;
import kd.sdk.kingscript.lib.version.ScriptVersionStore;

public class ScriptVersionManager {
    private static final Map<String, String> pathMap = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> antiPathMap = new ConcurrentHashMap<String, String>();
    private static ScriptVersionStore store;

    public static void setSamePath(String path, String samePath, Collection<LibModule> libModules) {
        if (!(path = ScriptPathFormat.format(path, libModules)).equals(samePath = ScriptPathFormat.format(samePath, libModules))) {
            pathMap.put(path, samePath);
            antiPathMap.put(samePath, path);
        }
    }

    public static String getSamePath(String anyPath, Collection<LibModule> libModules) {
        String path = pathMap.get(anyPath = ScriptPathFormat.format(anyPath, libModules));
        if (path == null) {
            path = antiPathMap.get(anyPath);
        }
        return path;
    }

    public static void setVersion(String scriptPath, String version, Collection<LibModule> libModules) {
        scriptPath = ScriptPathFormat.format(scriptPath, libModules);
        ScriptVersionStore ss = ScriptVersionManager.getScriptVersionStore(scriptPath, libModules);
        ss.setVersion(scriptPath, version);
        String samePath = ScriptVersionManager.getSamePath(scriptPath, libModules);
        if (samePath != null) {
            ss.setVersion(samePath, version);
        }
    }

    public static String getVersion(String scriptPath, Collection<LibModule> libModules) {
        String samePath;
        ScriptVersionStore ss = ScriptVersionManager.getScriptVersionStore(scriptPath = ScriptPathFormat.format(scriptPath, libModules), libModules);
        String version = ss.getVersion(scriptPath);
        if (version == null && (samePath = ScriptVersionManager.getSamePath(scriptPath, libModules)) != null) {
            version = ss.getVersion(samePath);
        }
        return version;
    }

    public static void clearVersion(String scriptPath, Collection<LibModule> libModules) {
        scriptPath = ScriptPathFormat.format(scriptPath, libModules);
        ScriptVersionStore ss = ScriptVersionManager.getScriptVersionStore(scriptPath, libModules);
        ss.clearVersion(scriptPath);
        String samePath = ScriptVersionManager.getSamePath(scriptPath, libModules);
        if (samePath != null) {
            ss.clearVersion(samePath);
        }
    }

    private static ScriptVersionStore getScriptVersionStore(String scriptPath, Collection<LibModule> libModules) {
        if (store == LocalMemoryScriptVersionStore.INSTANCE) {
            return store;
        }
        if (ModuleExports.isConstVersionModule(scriptPath)) {
            return LocalMemoryScriptVersionStore.INSTANCE;
        }
        String samePath = ScriptVersionManager.getSamePath(scriptPath, libModules);
        if (samePath != null && ModuleExports.isConstVersionModule(samePath)) {
            return LocalMemoryScriptVersionStore.INSTANCE;
        }
        return store;
    }

    public static void clearAllIfLocalMemoryStore() {
        if (store == LocalMemoryScriptVersionStore.INSTANCE) {
            LocalMemoryScriptVersionStore.INSTANCE.clearAll();
            pathMap.clear();
            antiPathMap.clear();
        }
    }

    static {
        String vs = System.getProperty("kingscript.script.version.store");
        if (vs != null && !vs.isEmpty()) {
            try {
                Class<?> cls = Class.forName(vs);
                store = (ScriptVersionStore)cls.newInstance();
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        } else {
            store = LocalMemoryScriptVersionStore.INSTANCE;
        }
    }
}

