/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.version;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import java.util.Map;
import java.util.function.Supplier;
import kd.sdk.kingscript.engine.EvalContext;
import kd.sdk.kingscript.engine.GlobalCache;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.ScriptPathFormat;

public final class VersionedModuleLoader {
    public static JSModuleRecord resolveImport(String canonicalPath, Supplier<JSModuleRecord> importResolver) {
        Map<String, JSModuleRecord> moduleMap = GlobalCache.get().getESModuleMap();
        JSModuleRecord imported = moduleMap.get(canonicalPath);
        if (imported != null) {
            if (!EvalContext.get().addImported(canonicalPath)) {
                KingScriptChanges.fixed("\u68c0\u6d4b\uff1a\u4f9d\u8d56\u7684\u811a\u672c\u6a21\u5757\u662f\u5426\u6709\u66f4\u65b0");
                String scriptPath = imported.getSource().getPath();
                LibFileSystem libFileSystem = KingScriptEngine.getCurrent().unwrap(KingScriptEngineImpl.class).getLibFileSystem();
                if (!libFileSystem.hasUpdated(scriptPath)) {
                    return imported;
                }
            } else {
                return imported;
            }
        }
        imported = importResolver.get();
        moduleMap.put(canonicalPath, imported);
        EvalContext.get().addImported(canonicalPath);
        return imported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSModuleRecord loadModule(Source source, Map<String, JSModuleRecord> moduleMap, JSModuleData moduleData, JSModuleLoader moduleLoader) {
        if (!source.isCached()) {
            return new JSModuleRecord(moduleData, moduleLoader);
        }
        String newVersionPath = source.getName();
        String canonicalPath = ScriptPathFormat.format(source.getPath());
        Map<String, String> esModuleLastVersionedPathMap = GlobalCache.get().getESModuleLastVersionedPathMap();
        Source source2 = source;
        synchronized (source2) {
            String oldVersionPath = esModuleLastVersionedPathMap.get(canonicalPath);
            if (oldVersionPath == null) {
                esModuleLastVersionedPathMap.put(canonicalPath, newVersionPath);
            } else if (!oldVersionPath.equals(newVersionPath)) {
                moduleMap.remove(oldVersionPath);
                esModuleLastVersionedPathMap.put(canonicalPath, newVersionPath);
            }
        }
        return moduleMap.computeIfAbsent(newVersionPath, key -> new JSModuleRecord(moduleData, moduleLoader));
    }
}

