/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.mixture;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.host.InterfacesCache;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.types.ScriptValue;
import org.slf4j.Logger;

public abstract class MixtureProxy
implements InvocationHandler {
    public static final String RESOURCE_NAME_KINGSCRIPTENGINE = "KingScriptEngine";
    protected static final Logger logger = Logs.getLogger();
    protected KingScriptEngine engine;
    protected ScriptValue mixture;
    protected final String scriptPath;
    private final Function<String, KingScriptEngine> autoDebugEngineCreator;

    protected MixtureProxy(String scriptPath, Function<String, KingScriptEngine> autoDebugEngineCreator) {
        this(scriptPath, autoDebugEngineCreator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MixtureProxy(String scriptPath, Function<String, KingScriptEngine> autoDebugEngineCreator, boolean init) {
        this.scriptPath = scriptPath;
        this.autoDebugEngineCreator = autoDebugEngineCreator;
        if (init) {
            try {
                this.engine = autoDebugEngineCreator.apply(scriptPath);
                this.engine.enter();
                try {
                    if (this.engine.isDebuggable()) {
                        this.engine.evalPath(scriptPath);
                    } else {
                        this.engine.evalLib(scriptPath);
                    }
                    this.mixture = this.getMixture();
                    this.onInitialized();
                }
                finally {
                    this.engine.leave();
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
                throw ScriptException.asRuntime(e);
            }
        }
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public Function<String, KingScriptEngine> getAutoDebugEngineCreator() {
        return this.autoDebugEngineCreator;
    }

    protected void initialize(KingScriptEngine engine) {
    }

    protected void onInitialized() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public final Object invoke(Object o, Method method, Object[] args) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Object call(String name, Object[] args) throws Throwable {
        if (logger.isInfoEnabled()) {
            logger.info(this.engine + "[" + this.scriptPath + "]call: " + name + " " + (args == null ? "[]" : Arrays.toString(args)));
        }
        if (this.engine != null) {
            this.engine.enter();
        }
        try {
            switch (name) {
                case "hashCode": {
                    if (args != null && args.length != 0) break;
                    Integer n = this.mixture.hashCode();
                    return n;
                }
                case "toString": {
                    if (args != null && args.length != 0) break;
                    String string = this.mixture.toString();
                    return string;
                }
            }
            Object object = this.doCall(name, args);
            return object;
        }
        catch (Throwable e) {
            logger.error("MixtureProxy call " + name + " error.", e);
            throw e;
        }
        finally {
            if (this.engine != null) {
                this.engine.leave();
            }
        }
    }

    protected Object doCall(String name, Object[] args) throws Throwable {
        ScriptValue member = this.mixture.getMember(name);
        ScriptValue ret = member.execute(args);
        return ret == null ? null : ret.asJavaObject();
    }

    protected final void closeEngine() {
        if (this.engine != null) {
            this.engine.close();
            this.engine = null;
        }
    }

    protected boolean isEngineClosed() {
        return this.engine == null;
    }

    Class<?>[] getInterfaces() {
        return InterfacesCache.getAllInterfaces(this.mixture.asJavaObject().getClass());
    }

    boolean isTypeOf(Class<?> typeCls) {
        Object obj = this.mixture.asJavaObject();
        return typeCls.isAssignableFrom(obj.getClass());
    }

    public final ScriptValue getCachedMixture() {
        return this.mixture;
    }

    protected abstract ScriptValue getMixture();
}

