/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.mixture;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.types.ScriptValue;

@Deprecated
public class PluginMixtureProxy
extends MixtureProxy {
    public static final String SCRIPT_PLUGIN_EXPORT_NAME = "plugin";
    private static List<String> blackClassNames = new ArrayList<String>(3);

    public PluginMixtureProxy(String scriptPath, Function<String, KingScriptEngine> autoDebugEngineCreator) {
        super(scriptPath, autoDebugEngineCreator, false);
    }

    @Override
    protected void onInitialized() {
        super.onInitialized();
        ScriptValue setPluginName = this.mixture.getMember("setPluginName");
        if (setPluginName != null) {
            setPluginName.execute(this.scriptPath);
        }
        this.mixture.getMember("__getPluginMixtureInterceptor").execute(new Object[0]).getMember("setEngine").execute(this.engine);
    }

    @Override
    protected ScriptValue getMixture() {
        try {
            return this.engine.getBindings().getExport().getMember(SCRIPT_PLUGIN_EXPORT_NAME).getMember("__jm");
        }
        catch (Throwable e) {
            String msg = e.getMessage() + ", " + this.scriptPath;
            try {
                Set<String> memberKeys = this.engine.getBindings().getExport().getMemberKeys();
                msg = msg + " export memberKeys: " + memberKeys;
            }
            catch (Throwable e2) {
                msg = msg + " export ScriptValue: " + this.engine.getBindings().getExport();
            }
            logger.error(msg);
            throw new ScriptException(msg, e);
        }
    }

    @Override
    protected Object call(String name, Object[] args) throws Throwable {
        Object loggableArgs;
        if (logger.isInfoEnabled()) {
            loggableArgs = this.filterLoggableArguments(args);
            logger.info(this.engine + "[" + this.scriptPath + "]call: " + name + " " + (args == null ? "[]" : Arrays.toString((Object[])loggableArgs)));
        }
        if (this.engine != null) {
            this.engine.enter();
        }
        try {
            switch (name) {
                case "hashCode": {
                    if (args != null && args.length != 0) break;
                    Integer n = this.mixture.hashCode();
                    return n;
                }
                case "toString": {
                    if (args != null && args.length != 0) break;
                    String string = this.mixture.toString();
                    return string;
                }
                case "getPluginName": {
                    if (args != null && args.length != 0) break;
                    String string = this.getPluginName();
                    return string;
                }
                case "destroy": 
                case "destory": 
                case "onReturnOperation": {
                    if (!this.isEngineClosed()) {
                        this.doCall(name, args);
                        this.destroy();
                    }
                    Object var5_11 = null;
                    return var5_11;
                }
                case "pageRelease": {
                    if (!this.isEngineClosed()) {
                        this.doCall(name, args);
                        this.onPageRelease();
                    }
                    Object var5_12 = null;
                    return var5_12;
                }
            }
            loggableArgs = this.doCall(name, args);
            return loggableArgs;
        }
        catch (Throwable e) {
            if ("registerListener".equals(name)) {
                Object var4_6 = null;
                return var4_6;
            }
            if (this.engine == null) {
                Object var4_7 = null;
                return var4_7;
            }
            logger.error("PluginMixtureProxy call " + name + " error.", e);
            throw e;
        }
        finally {
            if (this.engine != null) {
                this.engine.leave();
            }
        }
    }

    private Object[] filterLoggableArguments(Object[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        ArrayList<Object> allowLoggerArgs = new ArrayList<Object>(args.length);
        for (Object arg : args) {
            if (blackClassNames.contains(arg.getClass().getName())) continue;
            allowLoggerArgs.add(arg);
        }
        return allowLoggerArgs.toArray();
    }

    private void destroy() {
        this.closeEngine();
    }

    private void onPageRelease() {
        this.closeEngine();
    }

    private String getPluginName() {
        return this.scriptPath;
    }

    static {
        blackClassNames.add("kd.bos.form.events.LoadCustomControlMetasArgs");
        blackClassNames.add("kd.bos.form.events.LoadWaterMarkInfoEventArgs");
        blackClassNames.add("kd.bos.form.events.PreOpenFormEventArgs");
    }
}

