/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.mixture;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.ScriptImplement;
import kd.sdk.kingscript.types.ScriptValue;
import kd.sdk.kingscript.util.Tuple;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;

public final class ScriptImplementFactory {
    private static final Map<String, Class<?>> keyedClassMap = new ConcurrentHashMap();
    private static final Map<Class<?>, String> classScriptPathMap = new ConcurrentHashMap();
    private static final AtomicInteger clsSeq = new AtomicInteger();

    public static Class<?> defineInterface(String scriptPath, Class<?> ... interfaces) {
        scriptPath = ScriptPathFormat.format(scriptPath);
        HashSet set = new HashSet(Arrays.asList(interfaces));
        set.add(ScriptImplement.class);
        ArrayList classes = new ArrayList(set);
        Collections.sort(classes, Comparator.comparing(Class::getName));
        String key = scriptPath + '#' + classes;
        Class<?> cls = keyedClassMap.get(key);
        if (cls != null) {
            return cls;
        }
        Class definedCls = keyedClassMap.computeIfAbsent(key, k -> {
            String suffix = "kd.bos.kingscript.mixture.ScriptImplement_" + clsSeq.incrementAndGet();
            return ScriptImplementFactory.genInterface(suffix, classes.toArray(new Class[classes.size()]));
        });
        classScriptPathMap.put(definedCls, scriptPath);
        return definedCls;
    }

    public static <T> Tuple<MixtureProxy, Supplier<T>> newInstance(Class<T> definedInterfaceCls, final String exportName, Function<String, KingScriptEngine> autoDebugEngineCreator) {
        String scriptPath = classScriptPathMap.get(definedInterfaceCls);
        ScriptImplementMixtureProxy proxy = new ScriptImplementMixtureProxy(scriptPath, autoDebugEngineCreator){

            @Override
            protected ScriptValue getMixture() {
                return this.engine.getBindings().getExport().getMember(exportName);
            }
        };
        AtomicReference lazyCreateRef = new AtomicReference();
        Supplier<Object> sp = () -> {
            if (lazyCreateRef.get() == null) {
                lazyCreateRef.set(Proxy.newProxyInstance(definedInterfaceCls.getClassLoader(), new Class[]{definedInterfaceCls, ScriptImplement.class}, (InvocationHandler)proxy));
            }
            return lazyCreateRef.get();
        };
        return new Tuple<MixtureProxy, Supplier<T>>(proxy, sp);
    }

    public static void destroyInstance(Object scriptImplObject) {
        if (scriptImplObject instanceof ScriptImplement) {
            ((ScriptImplement)scriptImplObject).__closeScriptEngine();
        }
    }

    public static boolean isScriptImplement(Class<?> cls) {
        return ScriptImplement.class.isAssignableFrom(cls);
    }

    private static Class<?> genInterface(String name, Class<?> ... interfaces) {
        try {
            DynamicType.Builder bb = new ByteBuddy().makeInterface((Type[])interfaces).name(name);
            Class ret = bb.make().load(Thread.currentThread().getContextClassLoader()).getLoaded();
            return ret;
        }
        catch (Exception e) {
            throw ScriptException.wrap(e);
        }
    }

    private static abstract class ScriptImplementMixtureProxy
    extends MixtureProxy
    implements ScriptImplement {
        protected ScriptImplementMixtureProxy(String scriptPath, Function<String, KingScriptEngine> autoDebugEngineCreator) {
            super(scriptPath, autoDebugEngineCreator);
        }

        @Override
        protected Object call(String name, Object[] args) throws Throwable {
            if (name.equals("__closeScriptEngine")) {
                this.__closeScriptEngine();
                return null;
            }
            return super.call(name, args);
        }

        @Override
        public void __closeScriptEngine() {
            this.closeEngine();
        }
    }
}

