/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor;

import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadMonitor {
    private static final int MILI_TO_NANO = 1000000;
    private final long maxCPUTime;
    private final long maxMemory;
    private final int stageOffset;
    private final AtomicBoolean stop;
    private final AtomicBoolean scriptFinished;
    private final AtomicBoolean scriptKilled;
    private final AtomicBoolean cpuLimitExceeded;
    private final AtomicInteger memoryLimitExceededStage;
    private final Object monitor;
    private Thread threadToMonitor;
    private boolean timedOutWaitingForThreadToMonitor;
    private java.lang.management.ThreadMXBean threadBean;
    private final ThreadMXBean memoryCounter;

    public ThreadMonitor(long maxCPUTime, long maxMemory) {
        block5: {
            this.timedOutWaitingForThreadToMonitor = false;
            this.maxMemory = maxMemory;
            this.maxCPUTime = maxCPUTime * 1000000L;
            this.stop = new AtomicBoolean(false);
            this.scriptFinished = new AtomicBoolean(false);
            this.scriptKilled = new AtomicBoolean(false);
            this.cpuLimitExceeded = new AtomicBoolean(false);
            this.memoryLimitExceededStage = new AtomicInteger(0);
            this.monitor = new Object();
            this.stageOffset = maxMemory > 0x6400000L ? 2 : 0;
            try {
                this.threadBean = ManagementFactory.getThreadMXBean();
                this.threadBean.setThreadCpuTimeEnabled(true);
            }
            catch (UnsupportedOperationException ex) {
                if (maxCPUTime <= 0L) break block5;
                throw new UnsupportedOperationException("JVM does not support thread CPU time measurement");
            }
        }
        if (this.threadBean != null && this.threadBean instanceof ThreadMXBean) {
            this.memoryCounter = (ThreadMXBean)this.threadBean;
            this.memoryCounter.setThreadAllocatedMemoryEnabled(true);
        } else {
            if (maxMemory > 0L) {
                throw new UnsupportedOperationException("JVM does not support thread memory counting");
            }
            this.memoryCounter = null;
        }
    }

    private void reset() {
        this.stop.set(false);
        this.scriptFinished.set(false);
        this.scriptKilled.set(false);
        this.cpuLimitExceeded.set(false);
        this.memoryLimitExceededStage.set(0);
        this.threadToMonitor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            Object object = this.monitor;
            // MONITORENTER : object
            if (this.threadToMonitor == null) {
                this.monitor.wait((this.maxCPUTime + 500L) / 1000000L);
            }
            if (this.threadToMonitor == null) {
                this.timedOutWaitingForThreadToMonitor = true;
                throw new IllegalStateException("Executor thread not set after " + this.maxCPUTime / 1000000L + " ms\uff0cusually this means the sub-thread not started properly");
            }
            // MONITOREXIT : object
            long startCPUTime = this.getCPUTime();
            long stageMemory = this.getCurrentMemory();
            while (!this.stop.get()) {
                Object object2;
                long runtime = this.getCPUTime() - startCPUTime;
                long currentMemory = this.getCurrentMemory();
                long memory = currentMemory - stageMemory;
                boolean stageExided = this.isStageMemoryExided(memory);
                if (stageExided) {
                    this.memoryLimitExceededStage.incrementAndGet();
                    stageMemory = currentMemory;
                }
                if (this.isCpuTimeExided(runtime) || this.isMemoryLimitExceeded()) {
                    this.cpuLimitExceeded.set(this.isCpuTimeExided(runtime));
                    this.threadToMonitor.interrupt();
                    object2 = this.monitor;
                    // MONITORENTER : object2
                    this.monitor.wait(5L);
                    // MONITOREXIT : object2
                    if (this.stop.get()) {
                        return;
                    }
                    if (this.scriptFinished.get()) return;
                    this.stop.set(true);
                    this.threadToMonitor.interrupt();
                    this.scriptKilled.set(true);
                    return;
                }
                object2 = this.monitor;
                // MONITORENTER : object2
                long waitTime = this.getCheckInterval(runtime);
                if (waitTime == 0L) {
                    waitTime = 1L;
                }
                this.monitor.wait(waitTime);
                // MONITOREXIT : object2
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long getCheckInterval(long runtime) {
        if (this.maxCPUTime == 0L) {
            return 10L;
        }
        if (this.maxMemory == 0L) {
            return Math.max((this.maxCPUTime - runtime) / 1000000L, 5L);
        }
        return Math.min((this.maxCPUTime - runtime) / 1000000L, 5L);
    }

    private boolean isCpuTimeExided(long runtime) {
        if (this.maxCPUTime == 0L) {
            return false;
        }
        return runtime > this.maxCPUTime;
    }

    private boolean isStageMemoryExided(long memory) {
        if (this.maxMemory == 0L) {
            return false;
        }
        return memory > this.maxMemory >> this.stageOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentMemory() throws InterruptedException {
        if (this.maxMemory > 0L && this.memoryCounter != null) {
            Object object = this.monitor;
            synchronized (object) {
                return this.memoryCounter.getThreadAllocatedBytes(this.threadToMonitor.getId());
            }
        }
        return 0L;
    }

    private long getCPUTime() {
        if (this.maxCPUTime > 0L && this.threadBean != null) {
            return this.threadBean.getThreadCpuTime(this.threadToMonitor.getId());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor() {
        Object object = this.monitor;
        synchronized (object) {
            this.stop.set(true);
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerThreadToMonitor(Thread t) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.timedOutWaitingForThreadToMonitor) {
                return false;
            }
            this.reset();
            this.threadToMonitor = t;
            this.monitor.notifyAll();
            return true;
        }
    }

    public void scriptFinished() {
        this.scriptFinished.set(false);
    }

    public boolean isCPULimitExceeded() {
        return this.cpuLimitExceeded.get();
    }

    public boolean isMemoryLimitExceeded() {
        return this.memoryLimitExceededStage.get() >= 1 << this.stageOffset;
    }

    public boolean isScriptKilled() {
        return this.scriptKilled.get();
    }
}

