/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.cost.probe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.log.Loggable;
import kd.sdk.kingscript.monitor.cost.probe.config.DefaultProbeItemConfig;
import kd.sdk.kingscript.monitor.cost.probe.config.ProbeItemConfig;
import kd.sdk.kingscript.util.JsonUtil;

public final class ProbeConfig
implements Loggable {
    @ConfigurableItem(desc="\u63a2\u9488\u914d\u7f6e(json\u683c\u5f0f): [{'name':'xxx','maxTimes':10000,'checkImmediately':true,'allowLoop':false},{...},...]")
    public static final String CONFIG_KINGSCRIPT_MONITOR_PROBE_ITEMS = "kingscript.monitor.probe.items";
    @ConfigurableItem(desc="\u5faa\u73af\u68c0\u6d4b\u6b65\u957f")
    public static final String CONFIG_KINGSCRIPT_MONITOR_PROBE_LOOP_CHECK_STEP = "kingscript.monitor.probe.loopCheckStep";
    public static final String CONFIG_ITEM_NAME = "name";
    public static final String CONFIG_ITEM_CONFIG_CLASS = "configClass";
    public static final String CONFIG_ITEM_ALLOW_LOOP_ACCESS = "allowLoopAccess";
    public static final String CONFIG_ITEM_CHECK_IMMEDIATELY = "checkImmediately";
    public static final String CONFIG_ITEM_CHECK_LEVEL = "checkLevel";
    private static int loopCheckStep = 1;
    private static Map<String, ProbeItemConfig> itemConfigMap = new ConcurrentHashMap<String, ProbeItemConfig>();

    public static int getLoopCheckStep() {
        return loopCheckStep;
    }

    public static ProbeItemConfig get(String item) {
        return itemConfigMap.get(item);
    }

    private ProbeConfig() {
    }

    static {
        loopCheckStep = Integer.parseInt(System.getProperty(CONFIG_KINGSCRIPT_MONITOR_PROBE_LOOP_CHECK_STEP, String.valueOf(loopCheckStep)));
        String items = System.getProperty(CONFIG_KINGSCRIPT_MONITOR_PROBE_ITEMS);
        if (items != null && !items.isEmpty()) {
            JSONArray array = JsonUtil.parseArray(items);
            int n = array.size();
            for (int i = 0; i < n; ++i) {
                ProbeItemConfig config;
                JSONObject jsonObject;
                block5: {
                    jsonObject = array.getJSONObject(i);
                    String configClass = jsonObject.getString(CONFIG_ITEM_CONFIG_CLASS);
                    if (configClass != null) {
                        try {
                            Class<?> aClass = Class.forName(configClass);
                            config = (ProbeItemConfig)aClass.newInstance();
                            break block5;
                        }
                        catch (Exception e) {
                            logger.error("Create " + configClass + " error: " + e.getMessage(), (Throwable)e);
                            continue;
                        }
                    }
                    config = new DefaultProbeItemConfig();
                }
                config.initialize((Map<String, Object>)jsonObject);
                String name = jsonObject.getString(CONFIG_ITEM_NAME);
                if (name == null) continue;
                itemConfigMap.put(name, config);
                logger.info("ProbeConfig setup " + name + "=" + config);
            }
        }
    }
}

