/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.cost.probe;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.exception.LimitExceededException;
import kd.sdk.kingscript.monitor.cost.probe.ProbeConfig;
import kd.sdk.kingscript.monitor.cost.probe.action.LimitExceededAction;
import kd.sdk.kingscript.monitor.cost.probe.config.ProbeCheckLevel;
import kd.sdk.kingscript.monitor.cost.probe.config.ProbeItemConfig;
import kd.sdk.kingscript.monitor.cost.probe.data.ProbeData;

public final class ProbeContext {
    private static final ThreadLocal<ProbeContext> th = new ThreadLocal();
    private static final String DELIM = "#";
    private final ProbeContext parent = th.get();
    private final Map<String, ProbeData> summaryDataMap;

    public static void enter() {
        new ProbeContext();
    }

    public static void leave() {
        ProbeContext pc = th.get();
        if (pc != null) {
            pc.doLeave();
        }
    }

    public static ProbeContext get() {
        return th.get();
    }

    private ProbeContext() {
        this.summaryDataMap = this.parent == null ? new HashMap() : this.parent.summaryDataMap;
        th.set(this);
    }

    public Collection<ProbeData> getProbeData() {
        return Collections.unmodifiableCollection(this.summaryDataMap.values());
    }

    public ProbeData getProbeData(String name) {
        return this.summaryDataMap.get(name);
    }

    private void doLeave() {
        if (this.parent == null) {
            th.remove();
        } else {
            th.set(this.parent);
        }
        this.checkAtLeave();
    }

    void touch(ProbeData probeData) {
        ProbeItemConfig config = this.getConfig(probeData.getName());
        if (config != null) {
            ProbeData sumData = this.sum(probeData.getName(), probeData);
            if (config.isCheckImmediately()) {
                config.getChecker().check(sumData, config);
            }
        }
    }

    private ProbeData sum(String name, ProbeData probeData) {
        ProbeData sumData = this.summaryDataMap.get(name);
        if (sumData == null) {
            try {
                sumData = (ProbeData)probeData.getClass().newInstance();
                sumData.setName(name);
            }
            catch (Exception e) {
                throw new RuntimeException("New instance error: " + probeData.getClass().getName(), e);
            }
            this.summaryDataMap.put(name, sumData);
        }
        sumData.sum(probeData);
        return sumData;
    }

    private void checkAtLeave() {
        if (!this.summaryDataMap.isEmpty()) {
            TreeMap<ProbeCheckLevel, StringBuilder> sbMap = new TreeMap<ProbeCheckLevel, StringBuilder>();
            for (Map.Entry<String, ProbeData> entry : this.summaryDataMap.entrySet()) {
                String name = entry.getKey();
                ProbeItemConfig config = ProbeConfig.get(name);
                if (config == null || config.isCheckImmediately()) continue;
                ProbeData sumData = entry.getValue();
                try {
                    config.getChecker().check(sumData, config);
                }
                catch (LimitExceededException e) {
                    StringBuilder errors = sbMap.computeIfAbsent(config.getCheckLevel(), k -> new StringBuilder());
                    if (errors.length() != 0) {
                        errors.append('\n');
                    }
                    errors.append(e.getMessage());
                }
            }
            if (!sbMap.isEmpty()) {
                for (Map.Entry<String, ProbeData<Object>> entry : sbMap.entrySet()) {
                    LimitExceededAction.getAction((ProbeCheckLevel)((Object)entry.getKey())).onLimitExceeded(((StringBuilder)((Object)entry.getValue())).toString());
                }
            }
        }
    }

    private ProbeItemConfig getConfig(String name) {
        String accountId = AccountProvider.get().getAccountId();
        ProbeItemConfig accountConfig = ProbeConfig.get(accountId + DELIM + name);
        if (accountConfig != null) {
            return accountConfig;
        }
        return ProbeConfig.get(name);
    }
}

