/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.cost.probe;

import java.util.HashMap;
import java.util.Map;
import kd.sdk.kingscript.monitor.cost.probe.ProbeConfig;
import kd.sdk.kingscript.monitor.cost.probe.ProbeContext;
import kd.sdk.kingscript.monitor.cost.probe.action.LimitExceededAction;
import kd.sdk.kingscript.monitor.cost.probe.config.ProbeItemConfig;
import kd.sdk.kingscript.monitor.cost.probe.data.ProbeData;

public final class ProbeLoop
implements AutoCloseable {
    private ProbeContext probeContext;
    private Map<String, Integer> timesMap;
    private final int checkStep;
    private int checkStepIndex;
    private int round;
    private boolean thrown = false;

    ProbeLoop(int checkStep) {
        assert (checkStep > 0);
        this.checkStep = checkStep;
        this.probeContext = ProbeContext.get();
        this.timesMap = new HashMap<String, Integer>((int)((double)this.probeContext.getProbeData().size() / 0.75));
        for (ProbeData pd : this.probeContext.getProbeData()) {
            this.timesMap.put(pd.getName(), pd.getTimes());
        }
    }

    public void checkLoopAccess() {
        if (++this.checkStepIndex == this.checkStep) {
            this.checkStepIndex = 0;
            this.doCheckLoopAccess(true);
        }
        ++this.round;
    }

    private void doCheckLoopAccess(boolean checkImmediately) {
        for (ProbeData pd : this.probeContext.getProbeData()) {
            ProbeItemConfig config;
            String name = pd.getName();
            if (this.timesMap.containsKey(name) && this.timesMap.get(name).intValue() == pd.getTimes() || (config = ProbeConfig.get(name)).isAllowLoopAccess() || config.isCheckImmediately() != checkImmediately) continue;
            this.thrown = true;
            String checkRoundMessage = checkImmediately ? "rounding " + this.round : this.round + " rounded";
            LimitExceededAction.getAction(config.getCheckLevel()).onLimitExceeded("Not allow access the resources of \"" + name + "\" in loop(" + checkRoundMessage + ").");
        }
    }

    @Override
    public void close() {
        if (!this.thrown) {
            this.doCheckLoopAccess(false);
        }
    }
}

