/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.CostData;
import kd.sdk.kingscript.monitor.report.Reporter;
import kd.sdk.kingscript.monitor.stat.Stat;
import org.slf4j.Logger;

public final class ReportService {
    @ConfigurableItem(desc="monitor reporter\u914d\u7f6e")
    public static final String REPORTERS = "kingscript.monitor.reporters";
    @ConfigurableItem(desc="monitor report interval\u914d\u7f6e(ms)")
    public static final String INTERVAL = "kingscript.monitor.report.interval";
    private static long ts_interval = 30000L;
    private static final Logger logger = Logs.getLogger();
    private static final Object lock = new Object();
    private static volatile boolean terminal = false;
    private static List<Reporter> reportList;

    private static List<Reporter> createReporters() {
        ArrayList<Reporter> list = new ArrayList<Reporter>();
        ReportService.addReportClass(list, "kd.bos.kingscript.console.monitor.KingScriptExecDBReport");
        String reporters = System.getProperty(REPORTERS);
        if (reporters != null) {
            for (String s : reporters.split(",")) {
                ReportService.addReportClass(list, s);
            }
        }
        logger.info("Create monitor reporters: " + list);
        return list;
    }

    private static void addReportClass(List<Reporter> list, String s) {
        if (!(s = s.trim()).isEmpty()) {
            try {
                Class<?> cls = Class.forName(s);
                list.add((Reporter)cls.newInstance());
            }
            catch (Exception e) {
                logger.warn("Create monitor reporter failed: " + s + ", cause by" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void start() {
        terminal = false;
        reportList = ReportService.createReporters();
        if (!reportList.isEmpty()) {
            try {
                ts_interval = Long.parseLong(System.getProperty(INTERVAL, String.valueOf(ts_interval)));
            }
            catch (NumberFormatException e) {
                logger.warn("kingscript.monitor.report.interval config is not a long value: " + System.getProperty(INTERVAL));
            }
        }
    }

    private static void report() {
        Map<String, Map<String, Map<String, CostData>>> values = Stat.consumeForReport();
        for (Reporter reporter : reportList) {
            try {
                reporter.reportDetail(values);
            }
            catch (Exception e) {
                logger.error(reporter + " report error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ReportService.report();
        logger.info("Stop monitor reporter service...");
        terminal = true;
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }
}

