/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.monitor.cost.CostData;

public final class StatFormatter {
    public static Map<String, List<CostData>> convert(Map<String, Map<String, CostData>> values) {
        HashMap<String, List<CostData>> map = new HashMap<String, List<CostData>>(values.size());
        for (Map.Entry<String, Map<String, CostData>> item : values.entrySet()) {
            map.put(item.getKey(), new ArrayList<CostData>(item.getValue().values()));
        }
        return map;
    }

    public static String format(Map<String, CostData> dataMap, String name) {
        StringBuilder msg = new StringBuilder(1024);
        msg.append("\n----------------------------").append(name).append("----------------------------");
        int maxLen = 10;
        for (String type : dataMap.keySet()) {
            if (maxLen >= type.length()) continue;
            maxLen = type.length();
        }
        for (CostData cd : dataMap.values()) {
            String type = StatFormatter.fillSpace(cd.getType(), maxLen);
            msg.append('\n').append(type).append("\ttimes=").append(cd.getTimes()).append("\tavg=").append(cd.getTotalCost() / (long)cd.getTimes()).append("\tmin=").append(cd.getMinCost()).append("\tmax=").append(cd.getMaxCost()).append("\ttotal=").append(cd.getTotalCost());
        }
        msg.append("\n------------------------------------------------------------------------------");
        return msg.toString();
    }

    private static String fillSpace(String type, int maxLen) {
        StringBuilder sb = new StringBuilder(maxLen);
        sb.append(type);
        for (int i = type.length(); i < maxLen; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

